/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.SegmentConverter;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.MergeType;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.RollupRecordAggregator;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.data.DimensionFieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.exception.InvalidConfigException;

public class MergeRollupSegmentConverter {
    private List<File> _inputIndexDirs;
    private File _workingDir;
    private IndexingConfig _indexingConfig;
    private String _tableName;
    private String _segmentName;
    private MergeType _mergeType;
    private Map<String, String> _rolllupPreAggregateType;

    private MergeRollupSegmentConverter(@Nonnull List<File> inputIndexDirs, @Nonnull File workingDir, @Nonnull String tableName, @Nonnull String segmentName, @Nonnull String mergeType, @Nullable Map<String, String> rollupPreAggregateType, @Nullable IndexingConfig indexingConfig) {
        this._inputIndexDirs = inputIndexDirs;
        this._workingDir = workingDir;
        this._tableName = tableName;
        this._segmentName = segmentName;
        this._mergeType = MergeType.fromString(mergeType);
        this._rolllupPreAggregateType = rollupPreAggregateType;
        this._indexingConfig = indexingConfig;
    }

    public List<File> convert() throws Exception {
        List<File> convertedSegments;
        switch (this._mergeType) {
            case CONCATENATE: {
                convertedSegments = this.concatenateSegments();
                break;
            }
            case ROLLUP: {
                Schema schema = new SegmentMetadataImpl(this._inputIndexDirs.get(0)).getSchema();
                convertedSegments = this.rollupSegments(schema);
                break;
            }
            default: {
                throw new InvalidConfigException("Invalid merge type : " + (Object)((Object)this._mergeType));
            }
        }
        return convertedSegments;
    }

    private List<File> concatenateSegments() throws Exception {
        SegmentConverter concatenateSegmentConverter = new SegmentConverter.Builder().setTableName(this._tableName).setSegmentName(this._segmentName).setInputIndexDirs(this._inputIndexDirs).setWorkingDir(this._workingDir).setRecordTransformer(row -> row).setIndexingConfig(this._indexingConfig).build();
        return concatenateSegmentConverter.convertSegment();
    }

    private List<File> rollupSegments(Schema schema) throws Exception {
        ArrayList<String> groupByColumns = new ArrayList<String>();
        for (DimensionFieldSpec dimensionFieldSpec : schema.getDimensionFieldSpecs()) {
            groupByColumns.add(dimensionFieldSpec.getName());
        }
        String timeColumn = schema.getTimeColumnName();
        if (timeColumn != null) {
            groupByColumns.add(timeColumn);
        }
        RecordTransformer rollupRecordTransformer = row -> row;
        RollupRecordAggregator rollupRecordAggregator = new RollupRecordAggregator(schema, this._rolllupPreAggregateType);
        SegmentConverter rollupSegmentConverter = new SegmentConverter.Builder().setTableName(this._tableName).setSegmentName(this._segmentName).setInputIndexDirs(this._inputIndexDirs).setWorkingDir(this._workingDir).setRecordTransformer(rollupRecordTransformer).setRecordAggregator(rollupRecordAggregator).setGroupByColumns(groupByColumns).setIndexingConfig(this._indexingConfig).build();
        return rollupSegmentConverter.convertSegment();
    }

    public static class Builder {
        private List<File> _inputIndexDirs;
        private File _workingDir;
        private String _mergeType;
        private String _tableName;
        private String _segmentName;
        private Map<String, String> _rollupPreAggregateType;
        private IndexingConfig _indexingConfig;

        public Builder setInputIndexDirs(List<File> inputIndexDirs) {
            this._inputIndexDirs = inputIndexDirs;
            return this;
        }

        public Builder setWorkingDir(File workingDir) {
            this._workingDir = workingDir;
            return this;
        }

        public Builder setMergeType(String mergeType) {
            this._mergeType = mergeType;
            return this;
        }

        public Builder setRollupPreAggregateType(Map<String, String> rollupPreAggregateType) {
            this._rollupPreAggregateType = rollupPreAggregateType;
            return this;
        }

        public Builder setIndexingConfig(IndexingConfig indexingConfig) {
            this._indexingConfig = indexingConfig;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public MergeRollupSegmentConverter build() {
            return new MergeRollupSegmentConverter(this._inputIndexDirs, this._workingDir, this._tableName, this._segmentName, this._mergeType, this._rollupPreAggregateType, this._indexingConfig);
        }
    }
}

