/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.aggregate.ValueAggregator;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.aggregate.ValueAggregatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordAggregator;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.Schema;

public class RollupRecordAggregator
implements RecordAggregator {
    private static final ValueAggregator DEFAULT_AGGREGATOR_FUNCTION = ValueAggregatorFactory.getValueAggregator(ValueAggregatorFactory.ValueAggregatorType.SUM.name());
    private Map<String, ValueAggregator> _valueAggregatorMap;
    private Schema _schema;

    public RollupRecordAggregator(Schema schema, Map<String, String> aggregateTypes) {
        this._schema = schema;
        this._valueAggregatorMap = new HashMap<String, ValueAggregator>();
        if (aggregateTypes != null) {
            for (Map.Entry<String, String> entry : aggregateTypes.entrySet()) {
                this._valueAggregatorMap.put(entry.getKey(), ValueAggregatorFactory.getValueAggregator(entry.getValue()));
            }
        }
    }

    @Override
    public GenericRow aggregateRecords(List<GenericRow> rows) {
        GenericRow resultRow = rows.get(0);
        for (int i = 1; i < rows.size(); ++i) {
            GenericRow currentRow = rows.get(i);
            for (MetricFieldSpec metric : this._schema.getMetricFieldSpecs()) {
                String metricName = metric.getName();
                ValueAggregator aggregator = this._valueAggregatorMap == null ? DEFAULT_AGGREGATOR_FUNCTION : this._valueAggregatorMap.getOrDefault(metricName, DEFAULT_AGGREGATOR_FUNCTION);
                Object aggregatedResult = aggregator.aggregate(resultRow.getValue(metricName), currentRow.getValue(metricName), metric);
                resultRow.putField(metricName, aggregatedResult);
            }
        }
        return resultRow;
    }
}

