/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.aggregate;

import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.aggregate.MaxValueAggregator;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.rollup.aggregate.SumValueAggregator;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static .ValueAggregator getValueAggregator(String name) {
        ValueAggregatorType aggregatorType = ValueAggregatorType.valueOf(name.toUpperCase());
        switch (aggregatorType) {
            case SUM: {
                return new SumValueAggregator();
            }
            case MAX: {
                return new MaxValueAggregator();
            }
        }
        throw new IllegalStateException("Unsupported value aggregator type : " + name);
    }

    public static enum ValueAggregatorType {
        SUM,
        MAX;

    }
}

