/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion.segment;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.MultiplePinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordPartitioner;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordTransformer;
import org.apache.pinot.common.data.Schema;

public class MapperRecordReader
implements RecordReader {
    private MultiplePinotSegmentRecordReader _recordReader;
    private RecordTransformer _recordTransformer;
    private RecordPartitioner _recordPartitioner;
    private int _totalNumPartition;
    private int _currentPartition;
    private GenericRow _nextRow = new GenericRow();
    private boolean _finished = false;
    private boolean _nextRowReturned = true;

    public MapperRecordReader(List<File> indexDirs, RecordTransformer recordTransformer, RecordPartitioner recordPartitioner, int totalNumPartition, int currentPartition) throws Exception {
        this._recordReader = new MultiplePinotSegmentRecordReader(indexDirs);
        this._recordPartitioner = recordPartitioner;
        this._recordTransformer = recordTransformer;
        this._totalNumPartition = totalNumPartition;
        this._currentPartition = currentPartition;
    }

    @Override
    public boolean hasNext() {
        if (this._finished) {
            return false;
        }
        if (!this._nextRowReturned) {
            return true;
        }
        while (this._recordReader.hasNext()) {
            this._nextRow = this._recordReader.next(this._nextRow);
            if (this._recordPartitioner.getPartitionFromRecord(this._nextRow, this._totalNumPartition) != this._currentPartition) continue;
            this._nextRow = this._recordTransformer.transformRecord(this._nextRow);
            if (this._nextRow == null) {
                this._nextRow = new GenericRow();
                continue;
            }
            this._nextRowReturned = false;
            return true;
        }
        this._finished = true;
        return false;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        Preconditions.checkState(!this._nextRowReturned);
        RecordReaderUtils.copyRow(this._nextRow, reuse);
        this._nextRowReturned = true;
        return reuse;
    }

    @Override
    public void rewind() {
        this._recordReader.rewind();
        this._nextRowReturned = true;
        this._finished = false;
    }

    @Override
    public Schema getSchema() {
        return this._recordReader.getSchema();
    }

    @Override
    public void close() throws IOException {
        this._recordReader.close();
    }
}

