/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion.segment;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordAggregator;
import org.apache.pinot.common.data.Schema;

public class ReducerRecordReader
implements RecordReader {
    private PinotSegmentRecordReader _recordReader;
    private RecordAggregator _recordAggregator;
    private List<String> _groupByColumns;
    private List<GenericRow> _rowGroup = new ArrayList<GenericRow>();
    private GenericRow _nextRow = new GenericRow();
    private boolean _finished = false;
    private boolean _nextRowReturned = true;

    public ReducerRecordReader(File indexDir, RecordAggregator recordAggregator, List<String> groupByColumns) throws Exception {
        this._recordReader = new PinotSegmentRecordReader(indexDir, null, groupByColumns);
        this._recordAggregator = recordAggregator;
        this._groupByColumns = groupByColumns;
    }

    @Override
    public boolean hasNext() {
        if (this._finished) {
            return false;
        }
        if (!this._nextRowReturned) {
            return true;
        }
        while (this._recordReader.hasNext()) {
            GenericRow currentRow = this._recordReader.next();
            if (this._rowGroup.isEmpty() || this.haveSameGroupByColumns(this._rowGroup.iterator().next(), currentRow)) {
                this._rowGroup.add(currentRow);
                continue;
            }
            this._nextRow = this._recordAggregator.aggregateRecords(this._rowGroup);
            this._rowGroup.clear();
            this._rowGroup.add(currentRow);
            this._nextRowReturned = false;
            return true;
        }
        this._finished = true;
        if (!this._rowGroup.isEmpty()) {
            this._nextRow = this._recordAggregator.aggregateRecords(this._rowGroup);
            this._rowGroup.clear();
            this._nextRowReturned = false;
            return true;
        }
        return false;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        Preconditions.checkState(!this._nextRowReturned);
        RecordReaderUtils.copyRow(this._nextRow, reuse);
        this._nextRowReturned = true;
        return reuse;
    }

    @Override
    public void rewind() {
        this._recordReader.rewind();
        this._rowGroup.clear();
        this._nextRowReturned = true;
        this._finished = false;
    }

    @Override
    public Schema getSchema() {
        return this._recordReader.getSchema();
    }

    @Override
    public void close() {
        this._recordReader.close();
    }

    private boolean haveSameGroupByColumns(GenericRow row1, GenericRow row2) {
        for (String columnName : this._groupByColumns) {
            Object value2;
            Object value1 = row1.getValue(columnName);
            if (value1.equals(value2 = row2.getValue(columnName))) continue;
            return false;
        }
        return true;
    }
}

