/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.$internal.org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineGroupByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineGroupByOperator.class);
    private static final String OPERATOR_NAME = "CombineGroupByOperator";
    private final List<Operator> _operators;
    private final BrokerRequest _brokerRequest;
    private final ExecutorService _executorService;
    private final long _timeOutMs;
    private final int _numGroupsLimit;

    public CombineGroupByOperator(List<Operator> operators, BrokerRequest brokerRequest, ExecutorService executorService, long timeOutMs, int numGroupsLimit) {
        Preconditions.checkArgument(brokerRequest.isSetAggregationsInfo() && brokerRequest.isSetGroupBy());
        this._operators = operators;
        this._brokerRequest = brokerRequest;
        this._executorService = executorService;
        this._timeOutMs = timeOutMs;
        this._numGroupsLimit = numGroupsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numOperators = this._operators.size();
        final CountDownLatch operatorLatch = new CountDownLatch(numOperators);
        final ConcurrentHashMap<String, Object[]> resultsMap = new ConcurrentHashMap<String, Object[]>();
        final AtomicInteger numGroups = new AtomicInteger();
        final ConcurrentLinkedQueue mergedProcessingExceptions = new ConcurrentLinkedQueue();
        AggregationFunctionContext[] aggregationFunctionContexts = AggregationFunctionUtils.getAggregationFunctionContexts(this._brokerRequest.getAggregationsInfo(), null);
        final int numAggregationFunctions = aggregationFunctionContexts.length;
        final AggregationFunction[] aggregationFunctions = new AggregationFunction[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            aggregationFunctions[i] = aggregationFunctionContexts[i].getAggregationFunction();
        }
        Future[] futures = new Future[numOperators];
        for (int i = 0; i < numOperators; ++i) {
            final int index = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                @Override
                public void runJob() {
                    try {
                        AggregationGroupByResult aggregationGroupByResult;
                        IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)((Operator)CombineGroupByOperator.this._operators.get(index)).nextBlock();
                        List<ProcessingException> processingExceptionsToMerge = intermediateResultsBlock.getProcessingExceptions();
                        if (processingExceptionsToMerge != null) {
                            mergedProcessingExceptions.addAll(processingExceptionsToMerge);
                        }
                        if ((aggregationGroupByResult = intermediateResultsBlock.getAggregationGroupByResult()) != null) {
                            Iterator<.GroupKeyGenerator.GroupKey> groupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                            while (groupKeyIterator.hasNext()) {
                                .GroupKeyGenerator.GroupKey groupKey = groupKeyIterator.next();
                                resultsMap.compute(groupKey._stringKey, (key, value) -> {
                                    block3: {
                                        block2: {
                                            if (value != null) break block2;
                                            if (numGroups.get() >= CombineGroupByOperator.this._numGroupsLimit) break block3;
                                            numGroups.getAndIncrement();
                                            value = new Object[numAggregationFunctions];
                                            for (int i = 0; i < numAggregationFunctions; ++i) {
                                                value[i] = aggregationGroupByResult.getResultForKey(groupKey, i);
                                            }
                                            break block3;
                                        }
                                        for (int i = 0; i < numAggregationFunctions; ++i) {
                                            value[i] = aggregationFunctions[i].merge(value[i], aggregationGroupByResult.getResultForKey(groupKey, i));
                                        }
                                    }
                                    return value;
                                });
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception processing CombineGroupBy for index {}, operator {}", new Object[]{index, ((Operator)CombineGroupByOperator.this._operators.get(index)).getClass().getName(), e});
                        mergedProcessingExceptions.add(QueryException.getException(QueryException.QUERY_EXECUTION_ERROR, e));
                    }
                    operatorLatch.countDown();
                }
            });
        }
        try {
            boolean opCompleted = operatorLatch.await(this._timeOutMs, TimeUnit.MILLISECONDS);
            if (!opCompleted) {
                String errorMessage = "Timed out while combining group-by results after " + this._timeOutMs + "ms";
                LOGGER.error(errorMessage);
                IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(new TimeoutException(errorMessage));
                return intermediateResultsBlock;
            }
            AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(aggregationFunctions, (int)this._brokerRequest.getGroupBy().getTopN());
            List<Map<String, Object>> trimmedResults = aggregationGroupByTrimmingService.trimIntermediateResultsMap(resultsMap);
            IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(aggregationFunctionContexts, trimmedResults, true);
            if (!mergedProcessingExceptions.isEmpty()) {
                mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(mergedProcessingExceptions));
            }
            ExecutionStatistics executionStatistics = new ExecutionStatistics();
            for (Operator operator : this._operators) {
                ExecutionStatistics executionStatisticsToMerge = operator.getExecutionStatistics();
                if (executionStatisticsToMerge == null) continue;
                executionStatistics.merge(executionStatisticsToMerge);
            }
            mergedBlock.setNumDocsScanned(executionStatistics.getNumDocsScanned());
            mergedBlock.setNumEntriesScannedInFilter(executionStatistics.getNumEntriesScannedInFilter());
            mergedBlock.setNumEntriesScannedPostFilter(executionStatistics.getNumEntriesScannedPostFilter());
            mergedBlock.setNumSegmentsProcessed(executionStatistics.getNumSegmentsProcessed());
            mergedBlock.setNumSegmentsMatched(executionStatistics.getNumSegmentsMatched());
            mergedBlock.setNumTotalRawDocs(executionStatistics.getNumTotalRawDocs());
            if (numGroups.get() >= this._numGroupsLimit) {
                mergedBlock.setNumGroupsLimitReached(true);
            }
            IntermediateResultsBlock intermediateResultsBlock = mergedBlock;
            return intermediateResultsBlock;
        }
        catch (Exception e) {
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(e);
            return intermediateResultsBlock;
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

