/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.CombineService;
import org.apache.pinot.$internal.org.apache.pinot.core.util.trace.TraceCallable;
import org.apache.pinot.$internal.org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.BrokerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineOperator.class);
    private static final String OPERATOR_NAME = "CombineOperator";
    private final List<Operator> _operators;
    private final BrokerRequest _brokerRequest;
    private final ExecutorService _executorService;
    private final long _timeOutMs;
    private static final int MIN_THREADS_PER_QUERY;
    private static final int MAX_THREADS_PER_QUERY;
    private static final int MIN_SEGMENTS_PER_THREAD = 10;

    public CombineOperator(List<Operator> operators, ExecutorService executorService, long timeOutMs, BrokerRequest brokerRequest) {
        this._operators = operators;
        this._executorService = executorService;
        this._brokerRequest = brokerRequest;
        this._timeOutMs = timeOutMs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        void var10_14;
        int i;
        final long startTime = System.currentTimeMillis();
        final long queryEndTime = System.currentTimeMillis() + this._timeOutMs;
        int numOperators = this._operators.size();
        final int numGroups = Math.min(numOperators, Math.max(MIN_THREADS_PER_QUERY, Math.min(MAX_THREADS_PER_QUERY, (numOperators + 10 - 1) / 10)));
        ArrayList operatorGroups = new ArrayList(numGroups);
        for (i = 0; i < numGroups; ++i) {
            operatorGroups.add(new ArrayList());
        }
        for (i = 0; i < numOperators; ++i) {
            ((List)operatorGroups.get(i % numGroups)).add(this._operators.get(i));
        }
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(numGroups);
        for (final List list : operatorGroups) {
            this._executorService.submit(new TraceRunnable(){

                @Override
                public void runJob() {
                    IntermediateResultsBlock mergedBlock = null;
                    try {
                        for (Operator operator : list) {
                            IntermediateResultsBlock blockToMerge = (IntermediateResultsBlock)operator.nextBlock();
                            if (mergedBlock == null) {
                                mergedBlock = blockToMerge;
                                continue;
                            }
                            try {
                                CombineService.mergeTwoBlocks(CombineOperator.this._brokerRequest, mergedBlock, blockToMerge);
                            }
                            catch (Exception e) {
                                LOGGER.error("Caught exception while merging two blocks (step 1).", (Throwable)e);
                                mergedBlock.addToProcessingExceptions(QueryException.getException(QueryException.MERGE_RESPONSE_ERROR, e));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while executing query.", (Throwable)e);
                        mergedBlock = new IntermediateResultsBlock(e);
                    }
                    assert (mergedBlock != null);
                    blockingQueue.offer(mergedBlock);
                }
            });
        }
        LOGGER.debug("Submitting operators to be run in parallel and it took:" + (System.currentTimeMillis() - startTime));
        Future<IntermediateResultsBlock> mergedBlockFuture = this._executorService.submit(new TraceCallable<IntermediateResultsBlock>(){

            @Override
            public IntermediateResultsBlock callJob() throws Exception {
                int mergedBlocksNumber = 0;
                IntermediateResultsBlock mergedBlock = null;
                while (mergedBlocksNumber < numGroups) {
                    if (mergedBlock == null) {
                        mergedBlock = (IntermediateResultsBlock)blockingQueue.poll(queryEndTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                        if (mergedBlock != null) {
                            ++mergedBlocksNumber;
                        }
                        LOGGER.debug("Got response from operator 0 after: {}", (Object)(System.currentTimeMillis() - startTime));
                        continue;
                    }
                    IntermediateResultsBlock blockToMerge = (IntermediateResultsBlock)blockingQueue.poll(queryEndTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    if (blockToMerge == null) continue;
                    try {
                        LOGGER.debug("Got response from operator {} after: {}", (Object)mergedBlocksNumber, (Object)(System.currentTimeMillis() - startTime));
                        CombineService.mergeTwoBlocks(CombineOperator.this._brokerRequest, mergedBlock, blockToMerge);
                        LOGGER.debug("Merged response from operator {} after: {}", (Object)mergedBlocksNumber, (Object)(System.currentTimeMillis() - startTime));
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while merging two blocks (step 2).", (Throwable)e);
                        mergedBlock.addToProcessingExceptions(QueryException.getException(QueryException.MERGE_RESPONSE_ERROR, e));
                    }
                    ++mergedBlocksNumber;
                }
                return mergedBlock;
            }
        });
        try {
            IntermediateResultsBlock intermediateResultsBlock = mergedBlockFuture.get(queryEndTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Caught InterruptedException.", (Throwable)e);
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(QueryException.getException(QueryException.FUTURE_CALL_ERROR, e));
        }
        catch (ExecutionException e) {
            LOGGER.error("Caught ExecutionException.", (Throwable)e);
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(QueryException.getException(QueryException.MERGE_RESPONSE_ERROR, e));
        }
        catch (TimeoutException e) {
            LOGGER.error("Caught TimeoutException", (Throwable)e);
            mergedBlockFuture.cancel(true);
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(QueryException.getException(QueryException.EXECUTION_TIMEOUT_ERROR, e));
        }
        ExecutionStatistics executionStatistics = new ExecutionStatistics();
        for (Operator operator : this._operators) {
            ExecutionStatistics executionStatisticsToMerge = operator.getExecutionStatistics();
            if (executionStatisticsToMerge == null) continue;
            executionStatistics.merge(executionStatisticsToMerge);
        }
        var10_14.setNumDocsScanned(executionStatistics.getNumDocsScanned());
        var10_14.setNumEntriesScannedInFilter(executionStatistics.getNumEntriesScannedInFilter());
        var10_14.setNumEntriesScannedPostFilter(executionStatistics.getNumEntriesScannedPostFilter());
        var10_14.setNumTotalRawDocs(executionStatistics.getNumTotalRawDocs());
        var10_14.setNumSegmentsProcessed(executionStatistics.getNumSegmentsProcessed());
        var10_14.setNumSegmentsMatched(executionStatistics.getNumSegmentsMatched());
        return var10_14;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    static {
        int numCores = Runtime.getRuntime().availableProcessors();
        MIN_THREADS_PER_QUERY = Math.max(1, (int)((double)numCores * 0.5));
        MAX_THREADS_PER_QUERY = Math.min(10, (int)((double)numCores * 0.5));
    }
}

