/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataFetcher;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;

public class ProjectionOperator
extends BaseOperator<ProjectionBlock> {
    private static final String OPERATOR_NAME = "ProjectionOperator";
    private final Map<String, DataSource> _dataSourceMap;
    private final Map<String, Block> _dataBlockMap;
    private final DocIdSetOperator _docIdSetOperator;
    private final DataBlockCache _dataBlockCache;

    public ProjectionOperator(@Nonnull Map<String, DataSource> dataSourceMap, @Nonnull DocIdSetOperator docIdSetOperator) {
        this._dataSourceMap = dataSourceMap;
        this._dataBlockMap = new HashMap<String, Block>(dataSourceMap.size());
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            this._dataBlockMap.put(entry.getKey(), (Block)entry.getValue().nextBlock());
        }
        this._docIdSetOperator = docIdSetOperator;
        this._dataBlockCache = new DataBlockCache(new DataFetcher(dataSourceMap));
    }

    public int getNumColumnsProjected() {
        return this._dataSourceMap.size();
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this._dataSourceMap;
    }

    @Override
    protected ProjectionBlock getNextBlock() {
        DocIdSetBlock docIdSetBlock = (DocIdSetBlock)this._docIdSetOperator.nextBlock();
        if (docIdSetBlock == null) {
            return null;
        }
        this._dataBlockCache.initNewBlock(docIdSetBlock.getDocIdSet(), docIdSetBlock.getSearchableLength());
        return new ProjectionBlock(this._dataBlockMap, this._dataBlockCache, docIdSetBlock);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._docIdSetOperator.getExecutionStatistics();
    }
}

