/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.IndexBasedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndDocIdIterator
implements BlockDocIdIterator {
    static final Logger LOGGER = LoggerFactory.getLogger(AndDocIdIterator.class);
    public final BlockDocIdIterator[] docIdIterators;
    public ScanBasedDocIdIterator[] scanBasedDocIdIterators;
    public final int[] docIdPointers;
    public boolean reachedEnd = false;
    public int currentDocId = -1;
    int currentMax = -1;
    private boolean hasScanBasedIterators;

    public AndDocIdIterator(BlockDocIdIterator[] blockDocIdIterators) {
        int numIndexBasedIterators = 0;
        int numScanBasedIterators = 0;
        for (int i = 0; i < blockDocIdIterators.length; ++i) {
            if (blockDocIdIterators[i] instanceof IndexBasedDocIdIterator) {
                ++numIndexBasedIterators;
                continue;
            }
            if (!(blockDocIdIterators[i] instanceof ScanBasedDocIdIterator)) continue;
            ++numScanBasedIterators;
        }
        if (numIndexBasedIterators > 0 && numScanBasedIterators > 0) {
            this.hasScanBasedIterators = true;
            int nonScanIteratorsSize = blockDocIdIterators.length - numScanBasedIterators;
            this.docIdIterators = new BlockDocIdIterator[nonScanIteratorsSize];
            this.scanBasedDocIdIterators = new ScanBasedDocIdIterator[numScanBasedIterators];
            int nonScanBasedIndex = 0;
            int scanBasedIndex = 0;
            for (int i = 0; i < blockDocIdIterators.length; ++i) {
                if (blockDocIdIterators[i] instanceof ScanBasedDocIdIterator) {
                    this.scanBasedDocIdIterators[scanBasedIndex++] = (ScanBasedDocIdIterator)blockDocIdIterators[i];
                    continue;
                }
                this.docIdIterators[nonScanBasedIndex++] = blockDocIdIterators[i];
            }
        } else {
            this.hasScanBasedIterators = false;
            this.docIdIterators = blockDocIdIterators;
        }
        this.docIdPointers = new int[this.docIdIterators.length];
        Arrays.fill(this.docIdPointers, -1);
    }

    @Override
    public int advance(int targetDocId) {
        if (this.currentDocId == Integer.MIN_VALUE) {
            return this.currentDocId;
        }
        if (this.currentDocId >= targetDocId) {
            return this.currentDocId;
        }
        this.currentMax = targetDocId - 1;
        return this.next();
    }

    @Override
    public int next() {
        if (this.currentDocId == Integer.MIN_VALUE) {
            return this.currentDocId;
        }
        ++this.currentMax;
        block0: for (int i = 0; i < this.docIdIterators.length; ++i) {
            this.docIdPointers[i] = this.docIdIterators[i].advance(this.currentMax);
            if (this.docIdPointers[i] == Integer.MIN_VALUE) {
                this.reachedEnd = true;
                this.currentMax = Integer.MIN_VALUE;
                break;
            }
            if (this.docIdPointers[i] > this.currentMax) {
                this.currentMax = this.docIdPointers[i];
                if (i > 0) {
                    i = -1;
                }
            }
            if (!this.hasScanBasedIterators || i != this.docIdIterators.length - 1) continue;
            for (ScanBasedDocIdIterator iterator : this.scanBasedDocIdIterators) {
                if (iterator.isMatch(this.currentMax)) continue;
                i = -1;
                ++this.currentMax;
                continue block0;
            }
        }
        this.currentDocId = this.currentMax;
        return this.currentDocId;
    }

    @Override
    public int currentDocId() {
        return this.currentDocId;
    }

    public String toString() {
        return Arrays.toString(this.docIdIterators);
    }
}

