/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;

public final class ArrayBasedDocIdIterator
implements BlockDocIdIterator {
    private final int[] _docIds;
    private final int _searchableLength;
    private int _currentIndex = -1;
    private int _currentDocId = -1;

    public ArrayBasedDocIdIterator(int[] docIds, int searchableLength) {
        this._docIds = docIds;
        this._searchableLength = searchableLength;
    }

    @Override
    public int next() {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        this._currentDocId = ++this._currentIndex == this._searchableLength ? Integer.MIN_VALUE : this._docIds[this._currentIndex];
        return this._currentDocId;
    }

    @Override
    public int advance(int targetDocId) {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (targetDocId <= this._currentDocId) {
            return this._currentDocId;
        }
        while (++this._currentIndex < this._searchableLength) {
            if (this._docIds[this._currentIndex] < targetDocId) continue;
            this._currentDocId = this._docIds[this._currentIndex];
            return this._currentDocId;
        }
        this._currentDocId = Integer.MIN_VALUE;
        return Integer.MIN_VALUE;
    }

    @Override
    public int currentDocId() {
        return this._currentDocId;
    }
}

