/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.IndexBasedDocIdIterator;
import org.roaringbitmap.IntIterator;

public final class BitmapDocIdIterator
implements IndexBasedDocIdIterator {
    private final IntIterator iterator;
    private int endDocId = Integer.MAX_VALUE;
    private int startDocId;
    private int currentDocId = -1;

    public BitmapDocIdIterator(IntIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public int currentDocId() {
        return this.currentDocId;
    }

    public void setStartDocId(int startDocId) {
        this.startDocId = startDocId;
    }

    public void setEndDocId(int endDocId) {
        this.endDocId = endDocId;
    }

    @Override
    public int next() {
        if (this.currentDocId == Integer.MIN_VALUE || !this.iterator.hasNext()) {
            this.currentDocId = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        this.currentDocId = this.iterator.next();
        while (this.currentDocId < this.startDocId && this.iterator.hasNext()) {
            this.currentDocId = this.iterator.next();
        }
        if (this.currentDocId < this.startDocId || this.endDocId < this.currentDocId) {
            this.currentDocId = Integer.MIN_VALUE;
        }
        return this.currentDocId;
    }

    @Override
    public int advance(int targetDocId) {
        if (targetDocId < this.currentDocId) {
            throw new IllegalArgumentException("Trying to move backwards to docId " + targetDocId + ", current position " + this.currentDocId);
        }
        if (this.currentDocId == targetDocId) {
            return this.currentDocId;
        }
        int curr = this.next();
        while (curr < targetDocId && curr != Integer.MIN_VALUE) {
            curr = this.next();
        }
        return curr;
    }

    public String toString() {
        return BitmapDocIdIterator.class.getSimpleName();
    }
}

