/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMultiValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MVScanDocIdIterator
implements ScanBasedDocIdIterator {
    BlockMultiValIterator valueIterator;
    int currentDocId = -1;
    final int[] intArray;
    private int startDocId;
    private int endDocId;
    private PredicateEvaluator evaluator;
    private String datasourceName;
    private int _numEntriesScanned = 0;

    public MVScanDocIdIterator(String datasourceName, BlockValSet blockValSet, BlockMetadata blockMetadata, PredicateEvaluator evaluator) {
        this.datasourceName = datasourceName;
        this.evaluator = evaluator;
        if (evaluator.isAlwaysFalse()) {
            this.intArray = new int[0];
            this.setStartDocId(Integer.MIN_VALUE);
            this.setEndDocId(Integer.MIN_VALUE);
            this.currentDocId = Integer.MIN_VALUE;
        } else {
            this.intArray = new int[blockMetadata.getMaxNumberOfMultiValues()];
            Arrays.fill(this.intArray, 0);
            this.setStartDocId(blockMetadata.getStartDocId());
            this.setEndDocId(blockMetadata.getEndDocId());
        }
        this.valueIterator = (BlockMultiValIterator)blockValSet.iterator();
    }

    public void setStartDocId(int startDocId) {
        this.startDocId = startDocId;
    }

    public void setEndDocId(int endDocId) {
        this.endDocId = endDocId;
    }

    @Override
    public boolean isMatch(int docId) {
        if (this.currentDocId == Integer.MIN_VALUE) {
            return false;
        }
        this.valueIterator.skipTo(docId);
        ++this._numEntriesScanned;
        int length = this.valueIterator.nextIntVal(this.intArray);
        return this.evaluator.applyMV(this.intArray, length);
    }

    @Override
    public int advance(int targetDocId) {
        if (this.currentDocId == Integer.MIN_VALUE) {
            return this.currentDocId;
        }
        if (targetDocId < this.startDocId) {
            targetDocId = this.startDocId;
        } else if (targetDocId > this.endDocId) {
            this.currentDocId = Integer.MIN_VALUE;
        }
        if (this.currentDocId >= targetDocId) {
            return this.currentDocId;
        }
        this.currentDocId = targetDocId - 1;
        this.valueIterator.skipTo(targetDocId);
        int next = this.next();
        return next;
    }

    @Override
    public int next() {
        if (this.currentDocId == Integer.MIN_VALUE) {
            return this.currentDocId;
        }
        while (this.valueIterator.hasNext() && this.currentDocId < this.endDocId) {
            ++this.currentDocId;
            ++this._numEntriesScanned;
            int length = this.valueIterator.nextIntVal(this.intArray);
            if (!this.evaluator.applyMV(this.intArray, length)) continue;
            return this.currentDocId;
        }
        this.currentDocId = Integer.MIN_VALUE;
        return Integer.MIN_VALUE;
    }

    @Override
    public int currentDocId() {
        return this.currentDocId;
    }

    public String toString() {
        return MVScanDocIdIterator.class.getSimpleName() + "[" + this.datasourceName + "]";
    }

    @Override
    public MutableRoaringBitmap applyAnd(MutableRoaringBitmap answer) {
        MutableRoaringBitmap result = new MutableRoaringBitmap();
        if (this.evaluator.isAlwaysFalse()) {
            return result;
        }
        IntIterator intIterator = answer.getIntIterator();
        int docId = -1;
        while (intIterator.hasNext() && docId < this.endDocId) {
            docId = intIterator.next();
            if (docId < this.startDocId) continue;
            this.valueIterator.skipTo(docId);
            ++this._numEntriesScanned;
            int length = this.valueIterator.nextIntVal(this.intArray);
            if (!this.evaluator.applyMV(this.intArray, length)) continue;
            result.add(docId);
        }
        return result;
    }

    @Override
    public int getNumEntriesScanned() {
        return this._numEntriesScanned;
    }
}

