/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.IndexBasedDocIdIterator;
import org.apache.pinot.common.utils.Pairs;

public final class SortedDocIdIterator
implements IndexBasedDocIdIterator {
    private List<Pairs.IntPair> pairs;
    private String datasourceName;
    int pairPointer = 0;
    int currentDocId = -1;

    public SortedDocIdIterator(String datasourceName, List<Pairs.IntPair> pairs) {
        this.datasourceName = datasourceName;
        this.pairs = pairs;
    }

    @Override
    public int advance(int targetDocId) {
        if (this.pairPointer == this.pairs.size() || targetDocId > this.pairs.get(this.pairs.size() - 1).getRight()) {
            this.pairPointer = this.pairs.size();
            this.currentDocId = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        if (this.currentDocId >= targetDocId) {
            return this.currentDocId;
        }
        while (this.pairPointer < this.pairs.size()) {
            if (this.pairs.get(this.pairPointer).getLeft() > targetDocId) {
                this.currentDocId = this.pairs.get(this.pairPointer).getLeft();
                break;
            }
            if (targetDocId >= this.pairs.get(this.pairPointer).getLeft() && targetDocId <= this.pairs.get(this.pairPointer).getRight()) {
                this.currentDocId = targetDocId;
                break;
            }
            ++this.pairPointer;
        }
        if (this.pairPointer == this.pairs.size()) {
            this.currentDocId = Integer.MIN_VALUE;
        }
        return this.currentDocId;
    }

    @Override
    public int next() {
        if (this.pairPointer == this.pairs.size() || this.currentDocId > this.pairs.get(this.pairs.size() - 1).getRight()) {
            this.pairPointer = this.pairs.size();
            this.currentDocId = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        ++this.currentDocId;
        if (this.pairPointer < this.pairs.size() && this.currentDocId > this.pairs.get(this.pairPointer).getRight()) {
            ++this.pairPointer;
            this.currentDocId = this.pairPointer == this.pairs.size() ? Integer.MIN_VALUE : this.pairs.get(this.pairPointer).getLeft();
        } else if (this.currentDocId < this.pairs.get(this.pairPointer).getLeft()) {
            this.currentDocId = this.pairs.get(this.pairPointer).getLeft();
        }
        return this.currentDocId;
    }

    @Override
    public int currentDocId() {
        return this.currentDocId;
    }

    public String toString() {
        return SortedDocIdIterator.class.getSimpleName() + " [ " + this.datasourceName + "]";
    }
}

