/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapDocIdSet
implements FilterBlockDocIdSet {
    private final ImmutableRoaringBitmap _bitmap;
    private int _startDocId;
    private int _endDocId;

    public BitmapDocIdSet(ImmutableRoaringBitmap[] bitmaps, int startDocId, int endDocId, boolean exclusive) {
        int numBitmaps = bitmaps.length;
        if (numBitmaps > 1) {
            MutableRoaringBitmap orBitmap = MutableRoaringBitmap.or((ImmutableRoaringBitmap[])bitmaps);
            if (exclusive) {
                orBitmap.flip(startDocId, endDocId + 1);
            }
            this._bitmap = orBitmap;
        } else if (numBitmaps == 1) {
            if (exclusive) {
                MutableRoaringBitmap bitmap = bitmaps[0].toMutableRoaringBitmap();
                bitmap.flip(startDocId, endDocId + 1);
                this._bitmap = bitmap;
            } else {
                this._bitmap = bitmaps[0];
            }
        } else {
            MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
            if (exclusive) {
                bitmap.add(startDocId, endDocId + 1);
            }
            this._bitmap = bitmap;
        }
        this._startDocId = startDocId;
        this._endDocId = endDocId;
    }

    @Override
    public int getMinDocId() {
        return this._startDocId;
    }

    @Override
    public int getMaxDocId() {
        return this._endDocId;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this._startDocId = startDocId;
    }

    @Override
    public void setEndDocId(int endDocId) {
        this._endDocId = endDocId;
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return 0L;
    }

    @Override
    public BlockDocIdIterator iterator() {
        BitmapDocIdIterator bitmapDocIdIterator = new BitmapDocIdIterator(this._bitmap.getIntIterator());
        bitmapDocIdIterator.setStartDocId(this._startDocId);
        bitmapDocIdIterator.setEndDocId(this._endDocId);
        return bitmapDocIdIterator;
    }

    @Override
    public <T> T getRaw() {
        return (T)this._bitmap;
    }
}

