/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.OrDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.SortedDocIdSet;
import org.apache.pinot.common.utils.Pairs;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class OrBlockDocIdSet
implements FilterBlockDocIdSet {
    private final List<FilterBlockDocIdSet> _docIdSets;
    private int _minDocId = Integer.MAX_VALUE;
    private int _maxDocId = Integer.MIN_VALUE;

    public OrBlockDocIdSet(List<FilterBlockDocIdSet> docIdSets) {
        this._docIdSets = docIdSets;
        for (FilterBlockDocIdSet docIdSet : docIdSets) {
            this._minDocId = Math.min(this._minDocId, docIdSet.getMinDocId());
            this._maxDocId = Math.max(this._maxDocId, docIdSet.getMaxDocId());
        }
    }

    @Override
    public int getMinDocId() {
        return this._minDocId;
    }

    @Override
    public int getMaxDocId() {
        return this._maxDocId;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this._minDocId = Math.max(this._minDocId, startDocId);
    }

    @Override
    public void setEndDocId(int endDocId) {
        this._maxDocId = Math.min(this._maxDocId, endDocId);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        long numEntriesScannedInFilter = 0L;
        for (FilterBlockDocIdSet docIdSet : this._docIdSets) {
            numEntriesScannedInFilter += docIdSet.getNumEntriesScannedInFilter();
        }
        return numEntriesScannedInFilter;
    }

    @Override
    public BlockDocIdIterator iterator() {
        boolean useBitmapOr = false;
        for (BlockDocIdSet blockDocIdSet : this._docIdSets) {
            if (!(blockDocIdSet instanceof BitmapDocIdSet)) continue;
            useBitmapOr = true;
            break;
        }
        if (useBitmapOr) {
            ArrayList<BlockDocIdIterator> iterators = new ArrayList<BlockDocIdIterator>();
            MutableRoaringBitmap mutableRoaringBitmap = new MutableRoaringBitmap();
            for (BlockDocIdSet blockDocIdSet : this._docIdSets) {
                if (blockDocIdSet instanceof SortedDocIdSet) {
                    List pairs = (List)blockDocIdSet.getRaw();
                    for (Pairs.IntPair pair : pairs) {
                        mutableRoaringBitmap.add(pair.getLeft(), pair.getRight() + 1);
                    }
                    continue;
                }
                if (blockDocIdSet instanceof BitmapDocIdSet) {
                    mutableRoaringBitmap.or((ImmutableRoaringBitmap)blockDocIdSet.getRaw());
                    continue;
                }
                iterators.add(blockDocIdSet.iterator());
            }
            IntIterator intIterator = mutableRoaringBitmap.getIntIterator();
            BitmapDocIdIterator bitmapDocIdIterator = new BitmapDocIdIterator(intIterator);
            bitmapDocIdIterator.setStartDocId(this._minDocId);
            bitmapDocIdIterator.setEndDocId(this._maxDocId);
            if (iterators.isEmpty()) {
                return bitmapDocIdIterator;
            }
            iterators.add(bitmapDocIdIterator);
            return new OrDocIdIterator(iterators.toArray(new BlockDocIdIterator[iterators.size()]), this._minDocId, this._maxDocId);
        }
        int numDocIdSets = this._docIdSets.size();
        BlockDocIdIterator[] blockDocIdIteratorArray = new BlockDocIdIterator[numDocIdSets];
        for (int i = 0; i < numDocIdSets; ++i) {
            blockDocIdIteratorArray[i] = this._docIdSets.get(i).iterator();
        }
        return new OrDocIdIterator(blockDocIdIteratorArray, this._minDocId, this._maxDocId);
    }

    @Override
    public <T> T getRaw() {
        throw new UnsupportedOperationException();
    }
}

