/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.SVScanDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;

public class ScanBasedSingleValueDocIdSet
implements FilterBlockDocIdSet {
    private final BlockValSet blockValSet;
    private SVScanDocIdIterator blockValSetBlockDocIdIterator;
    private String datasourceName;
    int startDocId;
    int endDocId;

    public ScanBasedSingleValueDocIdSet(String datasourceName, BlockValSet blockValSet, BlockMetadata blockMetadata, PredicateEvaluator evaluator) {
        this.datasourceName = datasourceName;
        this.blockValSet = blockValSet;
        this.blockValSetBlockDocIdIterator = new SVScanDocIdIterator(datasourceName, blockValSet, blockMetadata, evaluator);
        this.setStartDocId(blockMetadata.getStartDocId());
        this.setEndDocId(blockMetadata.getEndDocId());
    }

    @Override
    public int getMinDocId() {
        return this.startDocId;
    }

    @Override
    public int getMaxDocId() {
        return this.endDocId;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this.startDocId = startDocId;
        this.blockValSetBlockDocIdIterator.setStartDocId(startDocId);
    }

    @Override
    public void setEndDocId(int endDocId) {
        this.endDocId = endDocId;
        this.blockValSetBlockDocIdIterator.setEndDocId(endDocId);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return this.blockValSetBlockDocIdIterator.getNumEntriesScanned();
    }

    @Override
    public ScanBasedDocIdIterator iterator() {
        return this.blockValSetBlockDocIdIterator;
    }

    @Override
    public <T> T getRaw() {
        throw new UnsupportedOperationException("getRaw not supported for ScanBasedDocIdSet");
    }
}

