/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.EmptyBlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.SortedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.common.utils.Pairs;

public class SortedDocIdSet
implements FilterBlockDocIdSet {
    public final List<Pairs.IntPair> pairs;
    public final AtomicLong timeMeasure = new AtomicLong(0L);
    int startDocId;
    int endDocId;
    private String datasourceName;

    public SortedDocIdSet(String datasourceName, List<Pairs.IntPair> pairs) {
        this.datasourceName = datasourceName;
        this.pairs = pairs;
    }

    @Override
    public int getMinDocId() {
        if (this.pairs.size() > 0) {
            return this.pairs.get(0).getLeft();
        }
        return 0;
    }

    @Override
    public int getMaxDocId() {
        if (this.pairs.size() > 0) {
            return this.pairs.get(this.pairs.size() - 1).getRight();
        }
        return 0;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this.startDocId = startDocId;
    }

    @Override
    public void setEndDocId(int endDocId) {
        this.endDocId = endDocId;
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return 0L;
    }

    @Override
    public BlockDocIdIterator iterator() {
        if (this.pairs == null || this.pairs.isEmpty()) {
            return EmptyBlockDocIdIterator.getInstance();
        }
        return new SortedDocIdIterator(this.datasourceName, this.pairs);
    }

    @Override
    public <T> T getRaw() {
        return (T)this.pairs;
    }

    public String toString() {
        return this.pairs.toString();
    }
}

