/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;

public class StarTreeDocIdSet
implements FilterBlockDocIdSet {
    private int minDocId = -1;
    private int maxDocId = -1;
    private int currentDocId = -1;

    @Override
    public int getMinDocId() {
        return this.minDocId;
    }

    @Override
    public int getMaxDocId() {
        return this.maxDocId;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this.minDocId = startDocId;
    }

    @Override
    public void setEndDocId(int endDocId) {
        this.maxDocId = endDocId;
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return 0L;
    }

    @Override
    public BlockDocIdIterator iterator() {
        return new RangeBasedDocIdIterator(this.minDocId, this.maxDocId);
    }

    @Override
    public <T> T getRaw() {
        throw new UnsupportedOperationException("getRaw not supported for StarTreeDocIdSet");
    }

    public final class RangeBasedDocIdIterator
    implements BlockDocIdIterator {
        private int minDocId;
        private int maxDocId;

        public RangeBasedDocIdIterator(int minDocId, int maxDocId) {
            this.minDocId = minDocId;
            this.maxDocId = maxDocId;
        }

        @Override
        public int currentDocId() {
            return StarTreeDocIdSet.this.currentDocId;
        }

        @Override
        public int next() {
            if (StarTreeDocIdSet.this.currentDocId == -1) {
                StarTreeDocIdSet.this.currentDocId = this.minDocId;
            } else if (StarTreeDocIdSet.this.currentDocId != Integer.MIN_VALUE && StarTreeDocIdSet.this.currentDocId < this.maxDocId) {
                StarTreeDocIdSet.this.currentDocId++;
            } else {
                StarTreeDocIdSet.this.currentDocId = Integer.MIN_VALUE;
            }
            return StarTreeDocIdSet.this.currentDocId;
        }

        @Override
        public int advance(int targetDocId) {
            if (StarTreeDocIdSet.this.currentDocId == Integer.MIN_VALUE) {
                return StarTreeDocIdSet.this.currentDocId;
            }
            if (StarTreeDocIdSet.this.currentDocId >= targetDocId) {
                return StarTreeDocIdSet.this.currentDocId;
            }
            StarTreeDocIdSet.this.currentDocId = targetDocId - 1;
            return this.next();
        }
    }
}

