/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docvaliterators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockSingleValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.ReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;

public final class SingleValueIterator
extends BlockSingleValIterator {
    private final SingleColumnSingleValueReader _reader;
    private final int _numDocs;
    private final ReaderContext _context;
    private int _nextDocId;

    public SingleValueIterator(SingleColumnSingleValueReader reader, int numDocs) {
        this._reader = reader;
        this._numDocs = numDocs;
        this._context = this._reader.createContext();
    }

    @Override
    public int nextIntVal() {
        return this._reader.getInt(this._nextDocId++, this._context);
    }

    @Override
    public long nextLongVal() {
        return this._reader.getLong(this._nextDocId++, this._context);
    }

    @Override
    public float nextFloatVal() {
        return this._reader.getFloat(this._nextDocId++, this._context);
    }

    @Override
    public double nextDoubleVal() {
        return this._reader.getDouble(this._nextDocId++, this._context);
    }

    @Override
    public String nextStringVal() {
        return this._reader.getString(this._nextDocId++, this._context);
    }

    @Override
    public byte[] nextBytesVal() {
        return this._reader.getBytes(this._nextDocId++, this._context);
    }

    @Override
    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    @Override
    public void skipTo(int docId) {
        this._nextDocId = docId;
    }

    @Override
    public void reset() {
        this._nextDocId = 0;
    }
}

