/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docvalsets;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BaseBlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docvaliterators.SingleValueIterator;
import org.apache.pinot.common.data.FieldSpec;

public final class SingleValueSet
extends BaseBlockValSet {
    private final SingleColumnSingleValueReader _reader;
    private final int _numDocs;
    private final FieldSpec.DataType _dataType;

    public SingleValueSet(SingleColumnSingleValueReader reader, int numDocs, FieldSpec.DataType dataType) {
        this._reader = reader;
        this._numDocs = numDocs;
        this._dataType = dataType;
    }

    @Override
    public BlockValIterator iterator() {
        return new SingleValueIterator(this._reader, this._numDocs);
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataType;
    }

    @Override
    public void getIntValues(int[] inDocIds, int inStartPos, int inDocIdsSize, int[] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        if (this._dataType == FieldSpec.DataType.INT) {
            for (int i = inStartPos; i < inEndPos; ++i) {
                outValues[outStartPos++] = this._reader.getInt(inDocIds[i], context);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void getLongValues(int[] inDocIds, int inStartPos, int inDocIdsSize, long[] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        switch (this._dataType) {
            case INT: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getInt(inDocIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getLong(inDocIds[i], context);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void getFloatValues(int[] inDocIds, int inStartPos, int inDocIdsSize, float[] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        switch (this._dataType) {
            case INT: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getInt(inDocIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getLong(inDocIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getFloat(inDocIds[i], context);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void getDoubleValues(int[] inDocIds, int inStartPos, int inDocIdsSize, double[] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        switch (this._dataType) {
            case INT: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getInt(inDocIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getLong(inDocIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getFloat(inDocIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = inStartPos; i < inEndPos; ++i) {
                    outValues[outStartPos++] = this._reader.getDouble(inDocIds[i], context);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void getStringValues(int[] inDocIds, int inStartPos, int inDocIdsSize, String[] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        if (this._dataType == FieldSpec.DataType.STRING) {
            for (int i = inStartPos; i < inEndPos; ++i) {
                outValues[outStartPos++] = this._reader.getString(inDocIds[i], context);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void getBytesValues(int[] inDocIds, int inStartPos, int inDocIdsSize, byte[][] outValues, int outStartPos) {
        int inEndPos = inStartPos + inDocIdsSize;
        Object context = this._reader.createContext();
        if (this._dataType.equals((Object)FieldSpec.DataType.BYTES)) {
            for (int i = inStartPos; i < inEndPos; ++i) {
                outValues[outStartPos++] = this._reader.getBytes(inDocIds[i], context);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void getDictionaryIds(int[] inDocIds, int inStartPos, int inDocIdsSize, int[] outDictionaryIds, int outStartPos) {
        this._reader.readValues(inDocIds, inStartPos, inDocIdsSize, outDictionaryIds, outStartPos);
    }
}

