/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapBasedFilterOperator
extends BaseFilterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitmapBasedFilterOperator.class);
    private static final String OPERATOR_NAME = "BitmapBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final DataSource _dataSource;
    private final ImmutableRoaringBitmap[] _bitmaps;
    private final int _startDocId;
    private final int _endDocId;
    private final boolean _exclusive;

    BitmapBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int startDocId, int endDocId) {
        Preconditions.checkArgument(!predicateEvaluator.isAlwaysTrue() && !predicateEvaluator.isAlwaysFalse());
        this._predicateEvaluator = predicateEvaluator;
        this._dataSource = dataSource;
        this._bitmaps = null;
        this._startDocId = startDocId;
        this._endDocId = endDocId;
        this._exclusive = predicateEvaluator.isExclusive();
    }

    public BitmapBasedFilterOperator(ImmutableRoaringBitmap[] bitmaps, int startDocId, int endDocId, boolean exclusive) {
        this._predicateEvaluator = null;
        this._dataSource = null;
        this._bitmaps = bitmaps;
        this._startDocId = startDocId;
        this._endDocId = endDocId;
        this._exclusive = exclusive;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._bitmaps != null) {
            return new FilterBlock(new BitmapDocIdSet(this._bitmaps, this._startDocId, this._endDocId, this._exclusive));
        }
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        InvertedIndexReader invertedIndex = this._dataSource.getInvertedIndex();
        int length = dictIds.length;
        ArrayList<ImmutableRoaringBitmap> bitmaps = new ArrayList<ImmutableRoaringBitmap>(length);
        for (int dictId : dictIds) {
            ImmutableRoaringBitmap bitmap = (ImmutableRoaringBitmap)invertedIndex.getDocIds(dictId);
            if (bitmap == null) continue;
            bitmaps.add(bitmap);
        }
        int numBitmaps = bitmaps.size();
        if (numBitmaps != length) {
            LOGGER.info("Not all inverted indexes are generated, numDictIds: {}, numBitmaps: {}", (Object)length, (Object)numBitmaps);
        }
        return new FilterBlock(new BitmapDocIdSet(bitmaps.toArray(new ImmutableRoaringBitmap[numBitmaps]), this._startDocId, this._endDocId, this._exclusive));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

