/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.ScanBasedMultiValueDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.ScanBasedSingleValueDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;

public class ScanBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "ScanBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final DataSource _dataSource;
    private final int _startDocId;
    private final int _endDocId;

    ScanBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int startDocId, int endDocId) {
        Preconditions.checkArgument(!predicateEvaluator.isAlwaysTrue() && !predicateEvaluator.isAlwaysFalse());
        this._predicateEvaluator = predicateEvaluator;
        this._dataSource = dataSource;
        this._startDocId = startDocId;
        this._endDocId = endDocId;
    }

    @Override
    protected FilterBlock getNextBlock() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        Object nextBlock = this._dataSource.nextBlock();
        BlockValSet blockValueSet = nextBlock.getBlockValueSet();
        BlockMetadata blockMetadata = nextBlock.getMetadata();
        FilterBlockDocIdSet filterBlockDocIdSet = dataSourceMetadata.isSingleValue() ? new ScanBasedSingleValueDocIdSet(this._dataSource.getOperatorName(), blockValueSet, blockMetadata, this._predicateEvaluator) : new ScanBasedMultiValueDocIdSet(this._dataSource.getOperatorName(), blockValueSet, blockMetadata, this._predicateEvaluator);
        filterBlockDocIdSet.setStartDocId(this._startDocId);
        filterBlockDocIdSet.setEndDocId(this._endDocId);
        return new FilterBlock(filterBlockDocIdSet);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    public PredicateEvaluator getPredicateEvaluator() {
        return this._predicateEvaluator;
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSource.getDataSourceMetadata();
    }
}

