/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.SortedDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.IntRanges;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.common.utils.Pairs;

public class SortedInvertedIndexBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "SortedInvertedIndexBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final DataSource _dataSource;
    private final int _startDocId;
    private final int _endDocId;

    SortedInvertedIndexBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int startDocId, int endDocId) {
        Preconditions.checkArgument(!predicateEvaluator.isAlwaysTrue() && !predicateEvaluator.isAlwaysFalse());
        this._predicateEvaluator = predicateEvaluator;
        this._dataSource = dataSource;
        this._startDocId = startDocId;
        this._endDocId = endDocId;
    }

    @Override
    protected FilterBlock getNextBlock() {
        int[] dictIds;
        SortedIndexReader invertedIndex = (SortedIndexReader)this._dataSource.getInvertedIndex();
        ArrayList<Pairs.IntPair> pairs = new ArrayList<Pairs.IntPair>();
        boolean exclusive = this._predicateEvaluator.isExclusive();
        int[] nArray = dictIds = exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        if (0 < dictIds.length) {
            Arrays.sort(dictIds);
            Pairs.IntPair lastPair = invertedIndex.getDocIds(dictIds[0]);
            IntRanges.clip(lastPair, this._startDocId, this._endDocId);
            for (int i = 1; i < dictIds.length; ++i) {
                Pairs.IntPair currentPair = invertedIndex.getDocIds(dictIds[i]);
                IntRanges.clip(currentPair, this._startDocId, this._endDocId);
                if (IntRanges.isInvalid(lastPair)) {
                    lastPair = currentPair;
                    continue;
                }
                if (IntRanges.rangesAreMergeable(lastPair, currentPair)) {
                    IntRanges.mergeIntoFirst(lastPair, currentPair);
                    continue;
                }
                if (!IntRanges.isInvalid(lastPair)) {
                    pairs.add(lastPair);
                }
                lastPair = currentPair;
            }
            if (!IntRanges.isInvalid(lastPair)) {
                pairs.add(lastPair);
            }
        }
        if (exclusive) {
            ArrayList<Pairs.IntPair> newPairs = new ArrayList<Pairs.IntPair>();
            if (pairs.isEmpty()) {
                newPairs.add(new Pairs.IntPair(this._startDocId, this._endDocId));
            } else {
                Pairs.IntPair firstHole = (Pairs.IntPair)pairs.get(0);
                Pairs.IntPair firstRange = new Pairs.IntPair(this._startDocId, firstHole.getLeft() - 1);
                if (!IntRanges.isInvalid(firstRange)) {
                    newPairs.add(firstRange);
                }
                int pairCount = pairs.size();
                for (int i = 1; i < pairCount; ++i) {
                    Pairs.IntPair previousHole = (Pairs.IntPair)pairs.get(i - 1);
                    Pairs.IntPair currentHole = (Pairs.IntPair)pairs.get(i);
                    Pairs.IntPair range = new Pairs.IntPair(previousHole.getRight() + 1, currentHole.getLeft() - 1);
                    if (IntRanges.isInvalid(range)) continue;
                    newPairs.add(range);
                }
                Pairs.IntPair lastHole = (Pairs.IntPair)pairs.get(pairs.size() - 1);
                Pairs.IntPair lastRange = new Pairs.IntPair(lastHole.getRight() + 1, this._endDocId);
                if (!IntRanges.isInvalid(lastRange)) {
                    newPairs.add(lastRange);
                }
            }
            pairs = newPairs;
        }
        return new FilterBlock(new SortedDocIdSet(this._dataSource.getOperatorName(), pairs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

