/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.EqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class EqualsPredicateEvaluatorFactory {
    private EqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(EqPredicate eqPredicate, Dictionary dictionary) {
        return new DictionaryBasedEqPredicateEvaluator(eqPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(EqPredicate eqPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case LONG: {
                return new LongRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case STRING: {
                return new StringRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
    }

    private static final class StringRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _matchingValue;

        StringRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = eqPredicate.getEqualsValue();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _matchingValue;

        DoubleRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Double.parseDouble(eqPredicate.getEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValue == value;
        }
    }

    private static final class FloatRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _matchingValue;

        FloatRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Float.parseFloat(eqPredicate.getEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValue == value;
        }
    }

    private static final class LongRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _matchingValue;

        LongRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Long.parseLong(eqPredicate.getEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValue == value;
        }
    }

    private static final class IntRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _matchingValue;

        IntRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Integer.parseInt(eqPredicate.getEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValue == value;
        }
    }

    private static final class DictionaryBasedEqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _matchingDictId;
        final int[] _matchingDictIds;

        DictionaryBasedEqPredicateEvaluator(EqPredicate eqPredicate, Dictionary dictionary) {
            this._matchingDictId = dictionary.indexOf(eqPredicate.getEqualsValue());
            if (this._matchingDictId >= 0) {
                this._matchingDictIds = new int[]{this._matchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysTrue = true;
                }
            } else {
                this._matchingDictIds = new int[0];
                this._alwaysFalse = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictId == dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            return this._matchingDictIds;
        }
    }
}

