/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.EqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.InPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NEqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NotInPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RangePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RegexpLikePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.EqualsPredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.InPredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.NotEqualsPredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.NotInPredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.RegexpLikePredicateEvaluatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class PredicateEvaluatorProvider {
    private PredicateEvaluatorProvider() {
    }

    public static PredicateEvaluator getPredicateEvaluator(Predicate predicate, DataSource dataSource) {
        try {
            if (dataSource.getDataSourceMetadata().hasDictionary()) {
                Dictionary dictionary = dataSource.getDictionary();
                switch (predicate.getType()) {
                    case EQ: {
                        return EqualsPredicateEvaluatorFactory.newDictionaryBasedEvaluator((EqPredicate)predicate, dictionary);
                    }
                    case NEQ: {
                        return NotEqualsPredicateEvaluatorFactory.newDictionaryBasedEvaluator((NEqPredicate)predicate, dictionary);
                    }
                    case IN: {
                        return InPredicateEvaluatorFactory.newDictionaryBasedEvaluator((InPredicate)predicate, dictionary);
                    }
                    case NOT_IN: {
                        return NotInPredicateEvaluatorFactory.newDictionaryBasedEvaluator((NotInPredicate)predicate, dictionary);
                    }
                    case RANGE: {
                        return RangePredicateEvaluatorFactory.newDictionaryBasedEvaluator((RangePredicate)predicate, dictionary);
                    }
                    case REGEXP_LIKE: {
                        return RegexpLikePredicateEvaluatorFactory.newDictionaryBasedEvaluator((RegexpLikePredicate)predicate, dictionary);
                    }
                }
                throw new UnsupportedOperationException("Unsupported predicate type: " + (Object)((Object)predicate.getType()));
            }
            FieldSpec.DataType dataType = dataSource.getDataSourceMetadata().getDataType();
            switch (predicate.getType()) {
                case EQ: {
                    return EqualsPredicateEvaluatorFactory.newRawValueBasedEvaluator((EqPredicate)predicate, dataType);
                }
                case NEQ: {
                    return NotEqualsPredicateEvaluatorFactory.newRawValueBasedEvaluator((NEqPredicate)predicate, dataType);
                }
                case IN: {
                    return InPredicateEvaluatorFactory.newRawValueBasedEvaluator((InPredicate)predicate, dataType);
                }
                case NOT_IN: {
                    return NotInPredicateEvaluatorFactory.newRawValueBasedEvaluator((NotInPredicate)predicate, dataType);
                }
                case RANGE: {
                    return RangePredicateEvaluatorFactory.newRawValueBasedEvaluator((RangePredicate)predicate, dataType);
                }
                case REGEXP_LIKE: {
                    return RegexpLikePredicateEvaluatorFactory.newRawValueBasedEvaluator((RegexpLikePredicate)predicate, dataType);
                }
            }
            throw new UnsupportedOperationException("Unsupported predicate type: " + (Object)((Object)predicate.getType()));
        }
        catch (NumberFormatException e) {
            throw new BadQueryRequestException(e);
        }
    }
}

