/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;

public class DictionaryBasedAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "DictionaryBasedAggregationOperator";
    private final AggregationFunctionContext[] _aggregationFunctionContexts;
    private final Map<String, Dictionary> _dictionaryMap;
    private final long _totalRawDocs;
    private ExecutionStatistics _executionStatistics;

    public DictionaryBasedAggregationOperator(AggregationFunctionContext[] aggregationFunctionContexts, long totalRawDocs, Map<String, Dictionary> dictionaryMap) {
        this._aggregationFunctionContexts = aggregationFunctionContexts;
        this._dictionaryMap = dictionaryMap;
        this._totalRawDocs = totalRawDocs;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numAggregationFunctions = this._aggregationFunctionContexts.length;
        ArrayList aggregationResults = new ArrayList(numAggregationFunctions);
        for (AggregationFunctionContext aggregationFunctionContext : this._aggregationFunctionContexts) {
            AggregationResultHolder resultHolder;
            AggregationFunction function = aggregationFunctionContext.getAggregationFunction();
            AggregationFunctionType functionType = function.getType();
            String column = aggregationFunctionContext.getColumn();
            Dictionary dictionary = this._dictionaryMap.get(column);
            switch (functionType) {
                case MAX: {
                    resultHolder = new DoubleAggregationResultHolder(dictionary.getDoubleValue(dictionary.length() - 1));
                    break;
                }
                case MIN: {
                    resultHolder = new DoubleAggregationResultHolder(dictionary.getDoubleValue(0));
                    break;
                }
                case MINMAXRANGE: {
                    double max = dictionary.getDoubleValue(dictionary.length() - 1);
                    double min = dictionary.getDoubleValue(0);
                    resultHolder = new ObjectAggregationResultHolder();
                    resultHolder.setValue(new MinMaxRangePair(min, max));
                    break;
                }
                default: {
                    throw new IllegalStateException("Dictionary based aggregation operator does not support function type: " + (Object)((Object)functionType));
                }
            }
            aggregationResults.add(function.extractAggregationResult(resultHolder));
        }
        this._executionStatistics = new ExecutionStatistics(this._totalRawDocs, 0L, 0L, this._totalRawDocs);
        return new IntermediateResultsBlock(this._aggregationFunctionContexts, aggregationResults, false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

