/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.common.segment.SegmentMetadata;

public class MetadataBasedAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "MetadataBasedAggregationOperator";
    private final AggregationFunctionContext[] _aggregationFunctionContexts;
    private final Map<String, DataSource> _dataSourceMap;
    private final SegmentMetadata _segmentMetadata;
    private ExecutionStatistics _executionStatistics;

    public MetadataBasedAggregationOperator(AggregationFunctionContext[] aggregationFunctionContexts, SegmentMetadata segmentMetadata, Map<String, DataSource> dataSourceMap) {
        this._aggregationFunctionContexts = aggregationFunctionContexts;
        this._dataSourceMap = dataSourceMap;
        this._segmentMetadata = segmentMetadata;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numAggregationFunctions = this._aggregationFunctionContexts.length;
        ArrayList<Long> aggregationResults = new ArrayList<Long>(numAggregationFunctions);
        long totalRawDocs = this._segmentMetadata.getTotalRawDocs();
        for (AggregationFunctionContext aggregationFunctionContext : this._aggregationFunctionContexts) {
            AggregationFunctionType functionType = aggregationFunctionContext.getAggregationFunction().getType();
            Preconditions.checkState(functionType == AggregationFunctionType.COUNT, "Metadata based aggregation operator does not support function type: " + (Object)((Object)functionType));
            aggregationResults.add(totalRawDocs);
        }
        this._executionStatistics = new ExecutionStatistics(totalRawDocs, 0L, 0L, totalRawDocs);
        return new IntermediateResultsBlock(this._aggregationFunctionContexts, aggregationResults, false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

