/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionFetcher;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.utils.DataSchema;

public class SelectionOnlyOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "SelectionOnlyOperator";
    private final IndexSegment _indexSegment;
    private final ProjectionOperator _projectionOperator;
    private final DataSchema _dataSchema;
    private final Block[] _blocks;
    private final int _limitDocs;
    private final Collection<Serializable[]> _rowEvents;
    private ExecutionStatistics _executionStatistics;

    public SelectionOnlyOperator(IndexSegment indexSegment, Selection selection, ProjectionOperator projectionOperator) {
        this._indexSegment = indexSegment;
        this._limitDocs = selection.getSize();
        this._projectionOperator = projectionOperator;
        List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(selection.getSelectionColumns(), indexSegment);
        this._dataSchema = SelectionOperatorUtils.extractDataSchema(null, selectionColumns, indexSegment);
        this._blocks = new Block[selectionColumns.size()];
        this._rowEvents = new ArrayList<Serializable[]>();
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        ProjectionBlock projectionBlock;
        int numDocsScanned = 0;
        while ((projectionBlock = (ProjectionBlock)this._projectionOperator.nextBlock()) != null) {
            for (int i = 0; i < this._dataSchema.size(); ++i) {
                this._blocks[i] = projectionBlock.getBlock(this._dataSchema.getColumnName(i));
            }
            SelectionFetcher selectionFetcher = new SelectionFetcher(this._blocks, this._dataSchema);
            DocIdSetBlock docIdSetBlock = projectionBlock.getDocIdSetBlock();
            int numDocsToFetch = Math.min(docIdSetBlock.getSearchableLength(), this._limitDocs - this._rowEvents.size());
            numDocsScanned += numDocsToFetch;
            int[] docIdSet = docIdSetBlock.getDocIdSet();
            for (int i = 0; i < numDocsToFetch; ++i) {
                this._rowEvents.add(selectionFetcher.getRow(docIdSet[i]));
            }
            if (this._rowEvents.size() != this._limitDocs) continue;
            break;
        }
        long numEntriesScannedInFilter = this._projectionOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = numDocsScanned * this._projectionOperator.getNumColumnsProjected();
        long numTotalRawDocs = this._indexSegment.getSegmentMetadata().getTotalRawDocs();
        this._executionStatistics = new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalRawDocs);
        return new IntermediateResultsBlock(this._dataSchema, this._rowEvents);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

