/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorService;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.utils.DataSchema;

public class SelectionOrderByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "SelectionOrderByOperator";
    private final IndexSegment _indexSegment;
    private final ProjectionOperator _projectionOperator;
    private final Selection _selection;
    private final SelectionOperatorService _selectionOperatorService;
    private final DataSchema _dataSchema;
    private final Block[] _blocks;
    private final Set<String> _selectionColumns = new HashSet<String>();
    private ExecutionStatistics _executionStatistics;

    public SelectionOrderByOperator(IndexSegment indexSegment, Selection selection, ProjectionOperator projectionOperator) {
        this._indexSegment = indexSegment;
        this._selection = selection;
        this._projectionOperator = projectionOperator;
        this.initColumnarDataSourcePlanNodeMap(indexSegment);
        this._selectionOperatorService = new SelectionOperatorService(this._selection, indexSegment);
        this._dataSchema = this._selectionOperatorService.getDataSchema();
        this._blocks = new Block[this._selectionColumns.size()];
    }

    private void initColumnarDataSourcePlanNodeMap(IndexSegment indexSegment) {
        this._selectionColumns.addAll(this._selection.getSelectionColumns());
        if (this._selectionColumns.size() == 1 && this._selectionColumns.toArray(new String[0])[0].equals("*")) {
            this._selectionColumns.clear();
            for (String columnName : indexSegment.getPhysicalColumnNames()) {
                this._selectionColumns.add(columnName);
            }
        }
        if (this._selection.getSelectionSortSequence() != null) {
            for (SelectionSort selectionSort : this._selection.getSelectionSortSequence()) {
                this._selectionColumns.add(selectionSort.getColumn());
            }
        }
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        ProjectionBlock projectionBlock;
        int numDocsScanned = 0;
        while ((projectionBlock = (ProjectionBlock)this._projectionOperator.nextBlock()) != null) {
            for (int i = 0; i < this._dataSchema.size(); ++i) {
                this._blocks[i] = projectionBlock.getBlock(this._dataSchema.getColumnName(i));
            }
            DocIdSetBlock docIdSetBlock = projectionBlock.getDocIdSetBlock();
            this._selectionOperatorService.iterateOnBlocksWithOrdering(docIdSetBlock.getBlockDocIdSet().iterator(), this._blocks);
        }
        numDocsScanned = (int)((long)numDocsScanned + this._selectionOperatorService.getNumDocsScanned());
        long numEntriesScannedInFilter = this._projectionOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = numDocsScanned * this._projectionOperator.getNumColumnsProjected();
        long numTotalRawDocs = this._indexSegment.getSegmentMetadata().getTotalRawDocs();
        this._executionStatistics = new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalRawDocs);
        return new IntermediateResultsBlock(this._selectionOperatorService.getDataSchema(), this._selectionOperatorService.getRows());
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

