/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.util.ArrayCopyUtils;
import org.apache.pinot.common.data.FieldSpec;

public abstract class BaseTransformFunction
implements TransformFunction {
    protected static final TransformResultMetadata LONG_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, true, false);
    protected static final TransformResultMetadata DOUBLE_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, true, false);
    protected static final TransformResultMetadata STRING_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    private int[] _intValuesSV;
    private long[] _longValuesSV;
    private float[] _floatValuesSV;
    private double[] _doubleValuesSV;
    private String[] _stringValuesSV;
    private int[][] _intValuesMV;
    private long[][] _longValuesMV;
    private float[][] _floatValuesMV;
    private double[][] _doubleValuesMV;
    private String[][] _stringValuesMV;

    @Override
    public Dictionary getDictionary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToDictIdsSV(@Nonnull ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(@Nonnull ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case LONG: {
                long[] longValues = this.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy(longValues, this._intValuesSV, length);
                return this._intValuesSV;
            }
            case FLOAT: {
                float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy(floatValues, this._intValuesSV, length);
                return this._intValuesSV;
            }
            case DOUBLE: {
                double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy(doubleValues, this._intValuesSV, length);
                return this._intValuesSV;
            }
            case STRING: {
                String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy(stringValues, this._intValuesSV, length);
                return this._intValuesSV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] transformToLongValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[] intValues = this.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy(intValues, this._longValuesSV, length);
                return this._longValuesSV;
            }
            case FLOAT: {
                float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy(floatValues, this._longValuesSV, length);
                return this._longValuesSV;
            }
            case DOUBLE: {
                double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy(doubleValues, this._longValuesSV, length);
                return this._longValuesSV;
            }
            case STRING: {
                String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy(stringValues, this._longValuesSV, length);
                return this._longValuesSV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] transformToFloatValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[] intValues = this.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy(intValues, this._floatValuesSV, length);
                return this._floatValuesSV;
            }
            case LONG: {
                long[] longValues = this.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy(longValues, this._floatValuesSV, length);
                return this._floatValuesSV;
            }
            case DOUBLE: {
                double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy(doubleValues, this._floatValuesSV, length);
                return this._floatValuesSV;
            }
            case STRING: {
                String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy(stringValues, this._floatValuesSV, length);
                return this._floatValuesSV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] transformToDoubleValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[] intValues = this.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy(intValues, this._doubleValuesSV, length);
                return this._doubleValuesSV;
            }
            case LONG: {
                long[] longValues = this.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy(longValues, this._doubleValuesSV, length);
                return this._doubleValuesSV;
            }
            case FLOAT: {
                float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy(floatValues, this._doubleValuesSV, length);
                return this._doubleValuesSV;
            }
            case STRING: {
                String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy(stringValues, this._doubleValuesSV, length);
                return this._doubleValuesSV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] transformToStringValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[] intValues = this.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy(intValues, this._stringValuesSV, length);
                return this._stringValuesSV;
            }
            case LONG: {
                long[] longValues = this.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy(longValues, this._stringValuesSV, length);
                return this._stringValuesSV;
            }
            case FLOAT: {
                float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy(floatValues, this._stringValuesSV, length);
                return this._stringValuesSV;
            }
            case DOUBLE: {
                double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy(doubleValues, this._stringValuesSV, length);
                return this._stringValuesSV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToIntValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case LONG: {
                long[][] longValues = this.transformToLongValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = longValues[i].length;
                    this._intValuesMV[i] = new int[numValues];
                    ArrayCopyUtils.copy(longValues[i], this._intValuesMV[i], numValues);
                }
                return this._intValuesMV;
            }
            case FLOAT: {
                float[][] floatValues = this.transformToFloatValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = floatValues[i].length;
                    this._intValuesMV[i] = new int[numValues];
                    ArrayCopyUtils.copy(floatValues[i], this._intValuesMV[i], numValues);
                }
                return this._intValuesMV;
            }
            case DOUBLE: {
                double[][] doubleValues = this.transformToDoubleValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = doubleValues[i].length;
                    this._intValuesMV[i] = new int[numValues];
                    ArrayCopyUtils.copy(doubleValues[i], this._intValuesMV[i], numValues);
                }
                return this._intValuesMV;
            }
            case STRING: {
                String[][] stringValues = this.transformToStringValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = stringValues[i].length;
                    this._intValuesMV[i] = new int[numValues];
                    ArrayCopyUtils.copy(stringValues[i], this._intValuesMV[i], numValues);
                }
                return this._intValuesMV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] transformToLongValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[][] intValues = this.transformToIntValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = intValues[i].length;
                    this._longValuesMV[i] = new long[numValues];
                    ArrayCopyUtils.copy(intValues[i], this._longValuesMV[i], numValues);
                }
                return this._longValuesMV;
            }
            case FLOAT: {
                float[][] floatValues = this.transformToFloatValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = floatValues[i].length;
                    this._longValuesMV[i] = new long[numValues];
                    ArrayCopyUtils.copy(floatValues[i], this._longValuesMV[i], numValues);
                }
                return this._longValuesMV;
            }
            case DOUBLE: {
                double[][] doubleValues = this.transformToDoubleValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = doubleValues[i].length;
                    this._longValuesMV[i] = new long[numValues];
                    ArrayCopyUtils.copy(doubleValues[i], this._longValuesMV[i], numValues);
                }
                return this._longValuesMV;
            }
            case STRING: {
                String[][] stringValues = this.transformToStringValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = stringValues[i].length;
                    this._longValuesMV[i] = new long[numValues];
                    ArrayCopyUtils.copy(stringValues[i], this._longValuesMV[i], numValues);
                }
                return this._longValuesMV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] transformToFloatValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[][] intValues = this.transformToIntValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = intValues[i].length;
                    this._floatValuesMV[i] = new float[numValues];
                    ArrayCopyUtils.copy(intValues[i], this._floatValuesMV[i], numValues);
                }
                return this._floatValuesMV;
            }
            case LONG: {
                long[][] longValues = this.transformToLongValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = longValues[i].length;
                    this._floatValuesMV[i] = new float[numValues];
                    ArrayCopyUtils.copy(longValues[i], this._floatValuesMV[i], numValues);
                }
                return this._floatValuesMV;
            }
            case DOUBLE: {
                double[][] doubleValues = this.transformToDoubleValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = doubleValues[i].length;
                    this._floatValuesMV[i] = new float[numValues];
                    ArrayCopyUtils.copy(doubleValues[i], this._floatValuesMV[i], numValues);
                }
                return this._floatValuesMV;
            }
            case STRING: {
                String[][] stringValues = this.transformToStringValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = stringValues[i].length;
                    this._floatValuesMV[i] = new float[numValues];
                    ArrayCopyUtils.copy(stringValues[i], this._floatValuesMV[i], numValues);
                }
                return this._floatValuesMV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] transformToDoubleValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[][] intValues = this.transformToIntValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = intValues[i].length;
                    this._doubleValuesMV[i] = new double[numValues];
                    ArrayCopyUtils.copy(intValues[i], this._doubleValuesMV[i], numValues);
                }
                return this._doubleValuesMV;
            }
            case LONG: {
                long[][] longValues = this.transformToLongValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = longValues[i].length;
                    this._doubleValuesMV[i] = new double[numValues];
                    ArrayCopyUtils.copy(longValues[i], this._doubleValuesMV[i], numValues);
                }
                return this._doubleValuesMV;
            }
            case FLOAT: {
                float[][] floatValues = this.transformToFloatValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = floatValues[i].length;
                    this._doubleValuesMV[i] = new double[numValues];
                    ArrayCopyUtils.copy(floatValues[i], this._doubleValuesMV[i], numValues);
                }
                return this._doubleValuesMV;
            }
            case STRING: {
                String[][] stringValues = this.transformToStringValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = stringValues[i].length;
                    this._doubleValuesMV[i] = new double[numValues];
                    ArrayCopyUtils.copy(stringValues[i], this._doubleValuesMV[i], numValues);
                }
                return this._doubleValuesMV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] transformToStringValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        switch (this.getResultMetadata().getDataType()) {
            case INT: {
                int[][] intValues = this.transformToIntValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = intValues[i].length;
                    this._stringValuesMV[i] = new String[numValues];
                    ArrayCopyUtils.copy(intValues[i], this._stringValuesMV[i], numValues);
                }
                return this._stringValuesMV;
            }
            case LONG: {
                long[][] longValues = this.transformToLongValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = longValues[i].length;
                    this._stringValuesMV[i] = new String[numValues];
                    ArrayCopyUtils.copy(longValues[i], this._stringValuesMV[i], numValues);
                }
                return this._stringValuesMV;
            }
            case FLOAT: {
                float[][] floatValues = this.transformToFloatValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = floatValues[i].length;
                    this._stringValuesMV[i] = new String[numValues];
                    ArrayCopyUtils.copy(floatValues[i], this._stringValuesMV[i], numValues);
                }
                return this._stringValuesMV;
            }
            case DOUBLE: {
                double[][] doubleValues = this.transformToDoubleValuesMV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int numValues = doubleValues[i].length;
                    this._stringValuesMV[i] = new String[numValues];
                    ArrayCopyUtils.copy(doubleValues[i], this._stringValuesMV[i], numValues);
                }
                return this._stringValuesMV;
            }
        }
        throw new UnsupportedOperationException();
    }
}

