/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.AdditionTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.DivisionTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.ValueInTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class TransformFunctionFactory {
    private static final Map<String, Class<? extends TransformFunction>> TRANSFORM_FUNCTION_MAP = new HashMap<String, Class<? extends TransformFunction>>(){
        {
            this.put("add".toLowerCase(), AdditionTransformFunction.class);
            this.put("sub".toLowerCase(), .SubtractionTransformFunction.class);
            this.put("mult".toLowerCase(), .MultiplicationTransformFunction.class);
            this.put("div".toLowerCase(), DivisionTransformFunction.class);
            this.put("timeConvert".toLowerCase(), .TimeConversionTransformFunction.class);
            this.put("dateTimeConvert".toLowerCase(), .DateTimeConversionTransformFunction.class);
            this.put("valueIn".toLowerCase(), ValueInTransformFunction.class);
        }
    };

    private TransformFunctionFactory() {
    }

    public static void init(@Nonnull Set<Class<TransformFunction>> transformFunctionClasses) {
        for (Class<TransformFunction> transformFunctionClass : transformFunctionClasses) {
            TransformFunction transformFunction;
            try {
                transformFunction = transformFunctionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Caught exception while instantiating transform function from class: " + transformFunctionClass.toString(), e);
            }
            String transformFunctionName = transformFunction.getName().toLowerCase();
            if (TRANSFORM_FUNCTION_MAP.containsKey(transformFunctionName)) {
                throw new IllegalArgumentException("Transform function: " + transformFunctionName + " already exists");
            }
            TRANSFORM_FUNCTION_MAP.put(transformFunctionName, transformFunctionClass);
        }
    }

    public static TransformFunction get(@Nonnull TransformExpressionTree expression, @Nonnull Map<String, DataSource> dataSourceMap) {
        switch (expression.getExpressionType()) {
            case FUNCTION: {
                TransformFunction transformFunction;
                String functionName = expression.getValue();
                Class<? extends TransformFunction> transformFunctionClass = TRANSFORM_FUNCTION_MAP.get(functionName);
                if (transformFunctionClass == null) {
                    throw new BadQueryRequestException("Unsupported transform function: " + functionName);
                }
                try {
                    transformFunction = transformFunctionClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Caught exception while instantiating transform function: " + functionName, e);
                }
                List<TransformExpressionTree> children = expression.getChildren();
                ArrayList<TransformFunction> arguments = new ArrayList<TransformFunction>(children.size());
                for (TransformExpressionTree child : children) {
                    arguments.add(TransformFunctionFactory.get(child, dataSourceMap));
                }
                try {
                    transformFunction.init(arguments, dataSourceMap);
                }
                catch (Exception e) {
                    throw new BadQueryRequestException("Caught exception while initializing transform function: " + transformFunction.getName(), e);
                }
                return transformFunction;
            }
            case IDENTIFIER: {
                String columnName = expression.getValue();
                return new IdentifierTransformFunction(columnName, dataSourceMap.get(columnName));
            }
            case LITERAL: {
                return new LiteralTransformFunction(expression.getValue());
            }
        }
        throw new IllegalStateException();
    }
}

