/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.transformer.timeunit;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.transformer.timeunit.TimeUnitTransformer;
import org.joda.time.Chronology;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.ISOChronology;

public class CustomTimeUnitTransformer
implements TimeUnitTransformer {
    private TimeUnit _inputTimeUnit;
    private CustomTimeUnit _outputTimeUnit;

    public CustomTimeUnitTransformer(@Nonnull TimeUnit inputTimeUnit, @Nonnull String outputTimeUnitName) {
        this._inputTimeUnit = inputTimeUnit;
        this._outputTimeUnit = CustomTimeUnit.valueOf(outputTimeUnitName);
    }

    @Override
    public void transform(@Nonnull long[] input, @Nonnull long[] output, int length) {
        for (int i = 0; i < length; ++i) {
            output[i] = this._outputTimeUnit.fromMillis(this._inputTimeUnit.toMillis(input[i]));
        }
    }

    private static enum CustomTimeUnit {
        WEEKS{

            @Override
            long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.weeks().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        MONTHS{

            @Override
            long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.months().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        YEARS{

            @Override
            long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.years().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        };


        abstract long fromMillis(long var1);
    }
}

