/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.periodictask;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.org.apache.pinot.core.periodictask.PeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicTaskScheduler.class);
    private ScheduledExecutorService _executorService;
    private List<PeriodicTask> _tasksWithValidInterval;

    public void init(List<PeriodicTask> periodicTasks) {
        this._tasksWithValidInterval = new ArrayList<PeriodicTask>();
        for (PeriodicTask periodicTask : periodicTasks) {
            if (periodicTask.getIntervalInSeconds() > 0L) {
                LOGGER.info("Adding periodic task: {}", (Object)periodicTask);
                this._tasksWithValidInterval.add(periodicTask);
                continue;
            }
            LOGGER.info("Skipping periodic task: {}", (Object)periodicTask);
        }
    }

    public synchronized void start() {
        if (this._executorService != null) {
            LOGGER.warn("Periodic task scheduler already started");
        }
        if (this._tasksWithValidInterval.isEmpty()) {
            LOGGER.warn("No periodic task scheduled");
        } else {
            LOGGER.info("Starting periodic task scheduler with tasks: {}", this._tasksWithValidInterval);
            this._executorService = Executors.newScheduledThreadPool(this._tasksWithValidInterval.size());
            for (PeriodicTask periodicTask : this._tasksWithValidInterval) {
                periodicTask.start();
                this._executorService.scheduleWithFixedDelay(() -> {
                    try {
                        LOGGER.info("Starting {} with running frequency of {} seconds.", (Object)periodicTask.getTaskName(), (Object)periodicTask.getIntervalInSeconds());
                        periodicTask.run();
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Caught exception while running Task: {}", (Object)periodicTask.getTaskName(), (Object)e);
                    }
                }, periodicTask.getInitialDelayInSeconds(), periodicTask.getIntervalInSeconds(), TimeUnit.SECONDS);
            }
        }
    }

    public synchronized void stop() {
        if (this._executorService != null) {
            LOGGER.info("Stopping periodic task scheduler");
            this._executorService.shutdown();
            this._executorService = null;
        }
        if (this._tasksWithValidInterval != null) {
            LOGGER.info("Stopping all periodic tasks: {}", this._tasksWithValidInterval);
            this._tasksWithValidInterval.parallelStream().forEach(PeriodicTask::stop);
        }
    }
}

