/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.AggregationGroupByOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationGroupByPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationGroupByPlanNode.class);
    private final IndexSegment _indexSegment;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final List<AggregationInfo> _aggregationInfos;
    private final AggregationFunctionContext[] _functionContexts;
    private final GroupBy _groupBy;
    private final TransformPlanNode _transformPlanNode;
    private final StarTreeTransformPlanNode _starTreeTransformPlanNode;

    public AggregationGroupByPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull BrokerRequest brokerRequest, int maxInitialResultHolderCapacity, int numGroupsLimit) {
        this._indexSegment = indexSegment;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._aggregationInfos = brokerRequest.getAggregationsInfo();
        this._functionContexts = AggregationFunctionUtils.getAggregationFunctionContexts(this._aggregationInfos, indexSegment.getSegmentMetadata());
        this._groupBy = brokerRequest.getGroupBy();
        List<StarTreeV2> starTrees = indexSegment.getStarTrees();
        if (starTrees != null && !StarTreeUtils.isStarTreeDisabled(brokerRequest)) {
            HashSet<AggregationFunctionColumnPair> aggregationFunctionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
            for (AggregationInfo aggregationInfo : this._aggregationInfos) {
                aggregationFunctionColumnPairs.add(AggregationFunctionUtils.getFunctionColumnPair(aggregationInfo));
            }
            HashSet<TransformExpressionTree> groupByExpressions = new HashSet<TransformExpressionTree>();
            for (String expression : this._groupBy.getExpressions()) {
                groupByExpressions.add(TransformExpressionTree.compileToExpressionTree(expression));
            }
            FilterQueryTree filterQueryTree = RequestUtils.generateFilterQueryTree(brokerRequest);
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, groupByExpressions, filterQueryTree)) continue;
                this._transformPlanNode = null;
                this._starTreeTransformPlanNode = new StarTreeTransformPlanNode(starTreeV2, aggregationFunctionColumnPairs, groupByExpressions, filterQueryTree, brokerRequest.getDebugOptions());
                return;
            }
        }
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, brokerRequest);
        this._starTreeTransformPlanNode = null;
    }

    @Override
    public AggregationGroupByOperator run() {
        int numTotalRawDocs = this._indexSegment.getSegmentMetadata().getTotalRawDocs();
        if (this._transformPlanNode != null) {
            return new AggregationGroupByOperator(this._functionContexts, this._groupBy, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformPlanNode.run(), numTotalRawDocs, false);
        }
        return new AggregationGroupByOperator(this._functionContexts, this._groupBy, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._starTreeTransformPlanNode.run(), numTotalRawDocs, true);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Aggregation Group-by Plan Node:");
        LOGGER.debug(prefix + "Operator: AggregationGroupByOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: Aggregations - " + this._aggregationInfos);
        LOGGER.debug(prefix + "Argument 2: GroupBy - " + this._groupBy);
        if (this._transformPlanNode != null) {
            LOGGER.debug(prefix + "Argument 3: TransformPlanNode -");
            this._transformPlanNode.showTree(prefix + "    ");
        } else {
            LOGGER.debug(prefix + "Argument 3: StarTreeTransformPlanNode -");
            this._starTreeTransformPlanNode.showTree(prefix + "    ");
        }
    }
}

