/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.DictionaryBasedAggregationOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.request.AggregationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryBasedAggregationPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryBasedAggregationPlanNode.class);
    private final Map<String, Dictionary> _dictionaryMap;
    private final AggregationFunctionContext[] _aggregationFunctionContexts;
    private IndexSegment _indexSegment;

    public DictionaryBasedAggregationPlanNode(IndexSegment indexSegment, List<AggregationInfo> aggregationInfos) {
        this._indexSegment = indexSegment;
        this._dictionaryMap = new HashMap<String, Dictionary>();
        for (AggregationFunctionContext aggregationFunctionContext : this._aggregationFunctionContexts = AggregationFunctionUtils.getAggregationFunctionContexts(aggregationInfos, indexSegment.getSegmentMetadata())) {
            String column = aggregationFunctionContext.getColumn();
            if (this._dictionaryMap.containsKey(column)) continue;
            this._dictionaryMap.put(column, this._indexSegment.getDataSource(column).getDictionary());
        }
    }

    @Override
    public Operator run() {
        return new DictionaryBasedAggregationOperator(this._aggregationFunctionContexts, this._indexSegment.getSegmentMetadata().getTotalRawDocs(), this._dictionaryMap);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug("{} Segment Level Inner-Segment Plan Node:", (Object)prefix);
        LOGGER.debug("{} Operator: DictionaryBasedAggregationOperator", (Object)prefix);
        LOGGER.debug("{} IndexSegment: {}", (Object)prefix, (Object)this._indexSegment.getSegmentName());
    }
}

