/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.common.request.BrokerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocIdSetPlanNode
implements PlanNode {
    public static int MAX_DOC_PER_CALL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DocIdSetPlanNode.class);
    private final IndexSegment _indexSegment;
    private final FilterPlanNode _filterPlanNode;
    private final int _maxDocPerCall;

    public DocIdSetPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull BrokerRequest brokerRequest, int maxDocPerCall) {
        Preconditions.checkState(maxDocPerCall > 0 && maxDocPerCall <= MAX_DOC_PER_CALL);
        this._indexSegment = indexSegment;
        this._filterPlanNode = new FilterPlanNode(this._indexSegment, brokerRequest);
        this._maxDocPerCall = maxDocPerCall;
    }

    public DocIdSetPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull BrokerRequest brokerRequest) {
        this(indexSegment, brokerRequest, MAX_DOC_PER_CALL);
    }

    @Override
    public DocIdSetOperator run() {
        return new DocIdSetOperator(this._filterPlanNode.run(), this._maxDocPerCall);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "DocIdSetPlanNode Plan Node :");
        LOGGER.debug(prefix + "Operator: DocIdSetOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: FilterPlanNode:");
        this._filterPlanNode.showTree(prefix + "    ");
    }
}

