/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterPlanNode.class);
    private final BrokerRequest _brokerRequest;
    private final IndexSegment _segment;

    public FilterPlanNode(IndexSegment segment, BrokerRequest brokerRequest) {
        this._segment = segment;
        this._brokerRequest = brokerRequest;
    }

    @Override
    public BaseFilterOperator run() {
        FilterQueryTree rootFilterNode = RequestUtils.generateFilterQueryTree(this._brokerRequest);
        return FilterPlanNode.constructPhysicalOperator(rootFilterNode, this._segment, this._brokerRequest.getDebugOptions());
    }

    private static BaseFilterOperator constructPhysicalOperator(FilterQueryTree filterQueryTree, IndexSegment segment, @Nullable Map<String, String> debugOptions) {
        int numDocs = segment.getSegmentMetadata().getTotalRawDocs();
        if (filterQueryTree == null) {
            return new MatchAllFilterOperator(numDocs);
        }
        FilterOperator filterType = filterQueryTree.getOperator();
        if (filterType == FilterOperator.AND || filterType == FilterOperator.OR) {
            List<FilterQueryTree> childFilters = filterQueryTree.getChildren();
            ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
            if (filterType == FilterOperator.AND) {
                for (FilterQueryTree childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = FilterPlanNode.constructPhysicalOperator(childFilter, segment, debugOptions);
                    if (childFilterOperator.isResultEmpty()) {
                        return EmptyFilterOperator.getInstance();
                    }
                    if (childFilterOperator.isResultMatchingAll()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getAndFilterOperator(childFilterOperators, numDocs, debugOptions);
            }
            for (FilterQueryTree childFilter : childFilters) {
                BaseFilterOperator childFilterOperator = FilterPlanNode.constructPhysicalOperator(childFilter, segment, debugOptions);
                if (childFilterOperator.isResultMatchingAll()) {
                    return new MatchAllFilterOperator(numDocs);
                }
                if (childFilterOperator.isResultEmpty()) continue;
                childFilterOperators.add(childFilterOperator);
            }
            return FilterOperatorUtils.getOrFilterOperator(childFilterOperators, numDocs, debugOptions);
        }
        Predicate predicate = Predicate.newPredicate(filterQueryTree);
        DataSource dataSource = segment.getDataSource(filterQueryTree.getColumn());
        PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource);
        return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs);
    }

    @Override
    public void showTree(String prefix) {
        String treeStructure = prefix + "Filter Plan Node\n" + prefix + "Operator: Filter\n" + prefix + "Argument 0: " + this._brokerRequest.getFilterQuery();
        LOGGER.debug(treeStructure);
    }
}

