/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectionPlanNode.class);
    private final IndexSegment _indexSegment;
    private final Set<String> _projectionColumns;
    private final DocIdSetPlanNode _docIdSetPlanNode;

    public ProjectionPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull Set<String> projectionColumns, @Nonnull DocIdSetPlanNode docIdSetPlanNode) {
        this._indexSegment = indexSegment;
        this._projectionColumns = projectionColumns;
        this._docIdSetPlanNode = docIdSetPlanNode;
    }

    @Override
    public ProjectionOperator run() {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(this._projectionColumns.size());
        for (String column : this._projectionColumns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        return new ProjectionOperator(dataSourceMap, this._docIdSetPlanNode.run());
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Segment Level Inner-Segment Plan Node:");
        LOGGER.debug(prefix + "Operator: ProjectionOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: Projection Columns - " + this._projectionColumns);
        LOGGER.debug(prefix + "Argument 2: DocIdSet - ");
        this._docIdSetPlanNode.showTree(prefix + "    ");
    }
}

