/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.EmptySelectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.SelectionOnlyOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.ProjectionPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Selection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionPlanNode.class);
    private final IndexSegment _indexSegment;
    private final Selection _selection;
    private final ProjectionPlanNode _projectionPlanNode;

    public SelectionPlanNode(IndexSegment indexSegment, BrokerRequest brokerRequest) {
        this._indexSegment = indexSegment;
        this._selection = brokerRequest.getSelections();
        if (this._selection.getSize() > 0) {
            int maxDocPerNextCall = DocIdSetPlanNode.MAX_DOC_PER_CALL;
            if (!this._selection.isSetSelectionSortSequence()) {
                maxDocPerNextCall = Math.min(this._selection.getOffset() + this._selection.getSize(), maxDocPerNextCall);
            }
            DocIdSetPlanNode docIdSetPlanNode = new DocIdSetPlanNode(this._indexSegment, brokerRequest, maxDocPerNextCall);
            this._projectionPlanNode = new ProjectionPlanNode(this._indexSegment, SelectionOperatorUtils.extractSelectionRelatedColumns(this._selection, indexSegment), docIdSetPlanNode);
        } else {
            this._projectionPlanNode = null;
        }
    }

    @Override
    public Operator run() {
        if (this._selection.getSize() > 0) {
            if (this._selection.isSetSelectionSortSequence()) {
                return new SelectionOrderByOperator(this._indexSegment, this._selection, this._projectionPlanNode.run());
            }
            return new SelectionOnlyOperator(this._indexSegment, this._selection, this._projectionPlanNode.run());
        }
        return new EmptySelectionOperator(this._indexSegment, this._selection);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Segment Level Inner-Segment Plan Node:");
        if (this._selection.getSize() > 0) {
            if (this._selection.isSetSelectionSortSequence()) {
                LOGGER.debug(prefix + "Operator: SelectionOrderByOperator");
            } else {
                LOGGER.debug(prefix + "Operator: SelectionOnlyOperator");
            }
        } else {
            LOGGER.debug(prefix + "Operator: LimitZeroSelectionOperator");
        }
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: Selections - " + this._selection);
        if (this._selection.getSize() > 0) {
            LOGGER.debug(prefix + "Argument 2: Projection -");
            this._projectionPlanNode.showTree(prefix + "    ");
        }
    }
}

