/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.ProjectionPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformPlanNode.class);
    private final String _segmentName;
    private final ProjectionPlanNode _projectionPlanNode;
    private final Set<String> _projectionColumns = new HashSet<String>();
    private final Set<TransformExpressionTree> _expressionTrees = new HashSet<TransformExpressionTree>();

    public TransformPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull BrokerRequest brokerRequest) {
        this._segmentName = indexSegment.getSegmentName();
        this.extractColumnsAndTransforms(brokerRequest);
        this._projectionPlanNode = new ProjectionPlanNode(indexSegment, this._projectionColumns, new DocIdSetPlanNode(indexSegment, brokerRequest));
    }

    private void extractColumnsAndTransforms(@Nonnull BrokerRequest brokerRequest) {
        if (brokerRequest.isSetAggregationsInfo()) {
            for (AggregationInfo aggregationInfo : brokerRequest.getAggregationsInfo()) {
                if (aggregationInfo.getAggregationType().equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) continue;
                String expression = AggregationFunctionUtils.getColumn(aggregationInfo);
                TransformExpressionTree transformExpressionTree = TransformExpressionTree.compileToExpressionTree(expression);
                transformExpressionTree.getColumns(this._projectionColumns);
                this._expressionTrees.add(transformExpressionTree);
            }
            if (brokerRequest.isSetGroupBy()) {
                for (String expression : brokerRequest.getGroupBy().getExpressions()) {
                    TransformExpressionTree transformExpressionTree = TransformExpressionTree.compileToExpressionTree(expression);
                    transformExpressionTree.getColumns(this._projectionColumns);
                    this._expressionTrees.add(transformExpressionTree);
                }
            }
        } else {
            throw new UnsupportedOperationException("Transforms not supported in selection queries.");
        }
    }

    @Override
    public TransformOperator run() {
        return new TransformOperator(this._projectionPlanNode.run(), this._expressionTrees);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Segment Level Inner-Segment Plan Node:");
        LOGGER.debug(prefix + "Operator: TransformOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._segmentName);
        LOGGER.debug(prefix + "Argument 1: Projection -");
        this._projectionPlanNode.showTree(prefix + "    ");
    }
}

