/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AvgAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AvgMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.CountMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountHLLMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.FastHLLAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MaxAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MaxMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MinAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MinMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MinMaxRangeMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileEstMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileTDigestMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.SumAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.SumMVAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;

public class AggregationFunctionFactory {
    private AggregationFunctionFactory() {
    }

    @Nonnull
    public static AggregationFunction getAggregationFunction(@Nonnull String functionName) {
        try {
            String upperCaseFunctionName = functionName.toUpperCase();
            if (upperCaseFunctionName.startsWith("PERCENTILE")) {
                String remainingFunctionName = upperCaseFunctionName.substring(10);
                if (remainingFunctionName.matches("\\d+")) {
                    return new PercentileAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName));
                }
                if (remainingFunctionName.matches("EST\\d+")) {
                    return new PercentileEstAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName.substring(3)));
                }
                if (remainingFunctionName.matches("TDIGEST\\d+")) {
                    return new PercentileTDigestAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName.substring(7)));
                }
                if (remainingFunctionName.matches("\\d+MV")) {
                    return new PercentileMVAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName.substring(0, remainingFunctionName.length() - 2)));
                }
                if (remainingFunctionName.matches("EST\\d+MV")) {
                    return new PercentileEstMVAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName.substring(3, remainingFunctionName.length() - 2)));
                }
                if (remainingFunctionName.matches("TDIGEST\\d+MV")) {
                    return new PercentileTDigestMVAggregationFunction(AggregationFunctionFactory.parsePercentile(remainingFunctionName.substring(7, remainingFunctionName.length() - 2)));
                }
                throw new IllegalArgumentException();
            }
            switch (AggregationFunctionType.valueOf(upperCaseFunctionName)) {
                case COUNT: {
                    return new CountAggregationFunction();
                }
                case MIN: {
                    return new MinAggregationFunction();
                }
                case MAX: {
                    return new MaxAggregationFunction();
                }
                case SUM: {
                    return new SumAggregationFunction();
                }
                case AVG: {
                    return new AvgAggregationFunction();
                }
                case MINMAXRANGE: {
                    return new MinMaxRangeAggregationFunction();
                }
                case DISTINCTCOUNT: {
                    return new DistinctCountAggregationFunction();
                }
                case DISTINCTCOUNTHLL: {
                    return new DistinctCountHLLAggregationFunction();
                }
                case FASTHLL: {
                    return new FastHLLAggregationFunction();
                }
                case COUNTMV: {
                    return new CountMVAggregationFunction();
                }
                case MINMV: {
                    return new MinMVAggregationFunction();
                }
                case MAXMV: {
                    return new MaxMVAggregationFunction();
                }
                case SUMMV: {
                    return new SumMVAggregationFunction();
                }
                case AVGMV: {
                    return new AvgMVAggregationFunction();
                }
                case MINMAXRANGEMV: {
                    return new MinMaxRangeMVAggregationFunction();
                }
                case DISTINCTCOUNTMV: {
                    return new DistinctCountMVAggregationFunction();
                }
                case DISTINCTCOUNTHLLMV: {
                    return new DistinctCountHLLMVAggregationFunction();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid aggregation function name: " + functionName);
        }
    }

    private static int parsePercentile(String percentileString) {
        int percentile = Integer.parseInt(percentileString);
        Preconditions.checkState(percentile >= 0 && percentile <= 100);
        return percentile;
    }
}

