/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;

public enum AggregationFunctionType {
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    AVG("avg"),
    MINMAXRANGE("minMaxRange"),
    DISTINCTCOUNT("distinctCount"),
    DISTINCTCOUNTHLL("distinctCountHLL"),
    FASTHLL("fastHLL"),
    PERCENTILE("percentile"),
    PERCENTILEEST("percentileEst"),
    PERCENTILETDIGEST("percentileTDigest"),
    COUNTMV("countMV"),
    MINMV("minMV"),
    MAXMV("maxMV"),
    SUMMV("sumMV"),
    AVGMV("avgMV"),
    MINMAXRANGEMV("minMaxRangeMV"),
    DISTINCTCOUNTMV("distinctCountMV"),
    DISTINCTCOUNTHLLMV("distinctCountHLLMV"),
    PERCENTILEMV("percentileMV"),
    PERCENTILEESTMV("percentileEstMV"),
    PERCENTILETDIGESTMV("percentileTDigestMV");

    private final String _name;

    private AggregationFunctionType(String name) {
        this._name = name;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public boolean isOfType(AggregationFunctionType ... aggregationFunctionTypes) {
        for (AggregationFunctionType aggregationFunctionType : aggregationFunctionTypes) {
            if (this != aggregationFunctionType) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static AggregationFunctionType getAggregationFunctionType(@Nonnull String functionName) {
        try {
            String upperCaseFunctionName = functionName.toUpperCase();
            if (upperCaseFunctionName.startsWith("PERCENTILE")) {
                String remainingFunctionName = upperCaseFunctionName.substring(10);
                if (remainingFunctionName.matches("\\d+")) {
                    return PERCENTILE;
                }
                if (remainingFunctionName.matches("EST\\d+")) {
                    return PERCENTILEEST;
                }
                if (remainingFunctionName.matches("TDIGEST\\d+")) {
                    return PERCENTILETDIGEST;
                }
                if (remainingFunctionName.matches("\\d+MV")) {
                    return PERCENTILEMV;
                }
                if (remainingFunctionName.matches("EST\\d+MV")) {
                    return PERCENTILEESTMV;
                }
                if (remainingFunctionName.matches("TDIGEST\\d+MV")) {
                    return PERCENTILETDIGESTMV;
                }
                throw new IllegalArgumentException();
            }
            return AggregationFunctionType.valueOf(upperCaseFunctionName);
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid aggregation function name: " + functionName);
        }
    }
}

