/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.AvgPair;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class AvgAggregationFunction
implements AggregationFunction<AvgPair, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.AVG;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.AVG.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                double sum = 0.0;
                for (int i = 0; i < length; ++i) {
                    sum += valueArray[i];
                }
                this.setAggregationResult(aggregationResultHolder, sum, length);
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                double sum = 0.0;
                long count = 0L;
                for (int i = 0; i < length; ++i) {
                    AvgPair value = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                    sum += value.getSum();
                    count += value.getCount();
                }
                this.setAggregationResult(aggregationResultHolder, sum, count);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for AVG aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    protected void setAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder, double sum, long count) {
        AvgPair avgPair = (AvgPair)aggregationResultHolder.getResult();
        if (avgPair == null) {
            aggregationResultHolder.setValue(new AvgPair(sum, count));
        } else {
            avgPair.apply(sum, count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, valueArray[i], 1L);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    AvgPair value = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, value.getSum(), value.getCount());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for AVG aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value, 1L);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    AvgPair value = ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytesValues[i]);
                    double sum = value.getSum();
                    long count = value.getCount();
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, sum, count);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for AVG aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    protected void setGroupByResult(int groupKey, @Nonnull GroupByResultHolder groupByResultHolder, double sum, long count) {
        AvgPair avgPair = (AvgPair)groupByResultHolder.getResult(groupKey);
        if (avgPair == null) {
            groupByResultHolder.setValueForKey(groupKey, new AvgPair(sum, count));
        } else {
            avgPair.apply(sum, count);
        }
    }

    @Override
    @Nonnull
    public AvgPair extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        AvgPair avgPair = (AvgPair)aggregationResultHolder.getResult();
        if (avgPair == null) {
            return new AvgPair(0.0, 0L);
        }
        return avgPair;
    }

    @Override
    @Nonnull
    public AvgPair extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        AvgPair avgPair = (AvgPair)groupByResultHolder.getResult(groupKey);
        if (avgPair == null) {
            return new AvgPair(0.0, 0L);
        }
        return avgPair;
    }

    @Override
    @Nonnull
    public AvgPair merge(@Nonnull AvgPair intermediateResult1, @Nonnull AvgPair intermediateResult2) {
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull AvgPair intermediateResult) {
        long count = intermediateResult.getCount();
        if (count == 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        return intermediateResult.getSum() / (double)count;
    }
}

