/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.common.utils.DataSchema;

public class CountAggregationFunction
implements AggregationFunction<Long, Long> {
    private static final String COLUMN_NAME = AggregationFunctionType.COUNT.getName() + "_star";
    private static final double DEFAULT_INITIAL_VALUE = 0.0;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.COUNT;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return COLUMN_NAME;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        if (blockValSets.length == 0) {
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)length);
        } else {
            long[] valueArray = blockValSets[0].getLongValuesSV();
            long count = 0L;
            for (int i = 0; i < length; ++i) {
                count += valueArray[i];
            }
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        if (blockValSets.length == 0) {
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
            }
        } else {
            long[] valueArray = blockValSets[0].getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)valueArray[i]);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        if (blockValSets.length == 0) {
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
                }
            }
        } else {
            long[] valueArray = blockValSets[0].getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                long value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)value);
                }
            }
        }
    }

    @Override
    @Nonnull
    public Long extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        return (long)aggregationResultHolder.getDoubleResult();
    }

    @Override
    @Nonnull
    public Long extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        return (long)groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    @Nonnull
    public Long merge(@Nonnull Long intermediateResult1, @Nonnull Long intermediateResult2) {
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    @Nonnull
    public Long extractFinalResult(@Nonnull Long intermediateResult) {
        return intermediateResult;
    }
}

