/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class CountMVAggregationFunction
extends CountAggregationFunction {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.COUNTMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.COUNTMV.getName() + "_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        int[] valueArray = blockValSets[0].getNumMVEntries();
        long count = 0L;
        for (int i = 0; i < length; ++i) {
            count += (long)valueArray[i];
        }
        aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)count);
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        int[] valueArray = blockValSets[0].getNumMVEntries();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        int[] valueArray = blockValSets[0].getNumMVEntries();
        for (int i = 0; i < length; ++i) {
            int value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)value);
            }
        }
    }
}

