/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class DistinctCountAggregationFunction
implements AggregationFunction<IntOpenHashSet, Integer> {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNT;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.DISTINCTCOUNT.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        IntOpenHashSet valueSet = DistinctCountAggregationFunction.getValueSet(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueSet.add(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueSet.add(Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueSet.add(Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueSet.add(Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueSet.add(stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    @Nonnull
    public IntOpenHashSet extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        IntOpenHashSet valueSet = (IntOpenHashSet)aggregationResultHolder.getResult();
        if (valueSet == null) {
            return new IntOpenHashSet();
        }
        return valueSet;
    }

    @Override
    @Nonnull
    public IntOpenHashSet extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        IntOpenHashSet valueSet = (IntOpenHashSet)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            return new IntOpenHashSet();
        }
        return valueSet;
    }

    @Override
    @Nonnull
    public IntOpenHashSet merge(@Nonnull IntOpenHashSet intermediateResult1, @Nonnull IntOpenHashSet intermediateResult2) {
        intermediateResult1.addAll((IntCollection)intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Integer extractFinalResult(@Nonnull IntOpenHashSet intermediateResult) {
        return intermediateResult.size();
    }

    private void setValueForGroupKey(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey, int value) {
        IntOpenHashSet valueSet = DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey);
        valueSet.add(value);
    }

    private void setValueForGroupKeys(@Nonnull GroupByResultHolder groupByResultHolder, int[] groupKeys, int value) {
        for (int groupKey : groupKeys) {
            this.setValueForGroupKey(groupByResultHolder, groupKey, value);
        }
    }

    protected static IntOpenHashSet getValueSet(@Nonnull AggregationResultHolder aggregationResultHolder) {
        IntOpenHashSet valueSet = (IntOpenHashSet)aggregationResultHolder.getResult();
        if (valueSet == null) {
            valueSet = new IntOpenHashSet();
            aggregationResultHolder.setValue(valueSet);
        }
        return valueSet;
    }

    protected static IntOpenHashSet getValueSet(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        IntOpenHashSet valueSet = (IntOpenHashSet)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new IntOpenHashSet();
            groupByResultHolder.setValueForKey(groupKey, valueSet);
        }
        return valueSet;
    }
}

