/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class DistinctCountHLLAggregationFunction
implements AggregationFunction<HyperLogLog, Long> {
    public static final int DEFAULT_LOG2M = 8;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTHLL;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.DISTINCTCOUNTHLL.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        HyperLogLog hyperLogLog = DistinctCountHLLAggregationFunction.getHyperLogLog(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.offer((Object)intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.offer((Object)longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.offer((Object)Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.offer((Object)doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.offer((Object)stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                try {
                    for (int i = 0; i < length; ++i) {
                        hyperLogLog.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
                }
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                try {
                    for (int i = 0; i < length; ++i) {
                        DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKeyArray[i], ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
                }
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSets[0].getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSets[0].getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSets[0].getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] singleValues = blockValSets[0].getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], singleValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                try {
                    for (int i = 0; i < length; ++i) {
                        DistinctCountHLLAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
                }
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    @Nonnull
    public HyperLogLog extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            return new HyperLogLog(8);
        }
        return hyperLogLog;
    }

    @Override
    @Nonnull
    public HyperLogLog extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            return new HyperLogLog(8);
        }
        return hyperLogLog;
    }

    @Override
    @Nonnull
    public HyperLogLog merge(@Nonnull HyperLogLog intermediateResult1, @Nonnull HyperLogLog intermediateResult2) {
        try {
            intermediateResult1.addAll(intermediateResult2);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLog", e);
        }
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Long extractFinalResult(@Nonnull HyperLogLog intermediateResult) {
        return intermediateResult.cardinality();
    }

    private static void setValueForGroupKey(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey, Object value) {
        HyperLogLog hyperLogLog = DistinctCountHLLAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
        hyperLogLog.offer(value);
    }

    private static void setValueForGroupKey(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey, HyperLogLog value) throws CardinalityMergeException {
        HyperLogLog hyperLogLog = DistinctCountHLLAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
        hyperLogLog.addAll(value);
    }

    private static void setValueForGroupKeys(@Nonnull GroupByResultHolder groupByResultHolder, int[] groupKeys, Object value) {
        for (int groupKey : groupKeys) {
            DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKey, value);
        }
    }

    private static void setValueForGroupKeys(@Nonnull GroupByResultHolder groupByResultHolder, int[] groupKeys, HyperLogLog value) throws CardinalityMergeException {
        for (int groupKey : groupKeys) {
            DistinctCountHLLAggregationFunction.setValueForGroupKey(groupByResultHolder, groupKey, value);
        }
    }

    protected static HyperLogLog getHyperLogLog(@Nonnull AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(8);
            aggregationResultHolder.setValue(hyperLogLog);
        }
        return hyperLogLog;
    }

    protected static HyperLogLog getHyperLogLog(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(8);
            groupByResultHolder.setValueForKey(groupKey, hyperLogLog);
        }
        return hyperLogLog;
    }
}

