/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.hll.HllUtil;
import org.apache.pinot.common.utils.DataSchema;

public class FastHLLAggregationFunction
implements AggregationFunction<HyperLogLog, Long> {
    private int _log2m = 8;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FASTHLL;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.FASTHLL.getName() + "_" + column;
    }

    public void setLog2m(int log2m) {
        this._log2m = log2m;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        String[] valueArray = blockValSets[0].getStringValuesSV();
        HyperLogLog hyperLogLog = this.getHyperLogLog(aggregationResultHolder);
        try {
            for (int i = 0; i < length; ++i) {
                hyperLogLog.addAll(HllUtil.convertStringToHll(valueArray[i]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        String[] valueArray = blockValSets[0].getStringValuesSV();
        try {
            for (int i = 0; i < length; ++i) {
                HyperLogLog hyperLogLog = this.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                hyperLogLog.addAll(HllUtil.convertStringToHll(valueArray[i]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        String[] valueArray = blockValSets[0].getStringValuesSV();
        try {
            for (int i = 0; i < length; ++i) {
                HyperLogLog value = HllUtil.convertStringToHll(valueArray[i]);
                for (int groupKey : groupKeysArray[i]) {
                    HyperLogLog hyperLogLog = this.getHyperLogLog(groupByResultHolder, groupKey);
                    hyperLogLog.addAll(value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while aggregating HyperLogLog", e);
        }
    }

    @Override
    @Nonnull
    public HyperLogLog extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            return new HyperLogLog(this._log2m);
        }
        return hyperLogLog;
    }

    @Override
    @Nonnull
    public HyperLogLog extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            return new HyperLogLog(this._log2m);
        }
        return hyperLogLog;
    }

    @Override
    @Nonnull
    public HyperLogLog merge(@Nonnull HyperLogLog intermediateResult1, @Nonnull HyperLogLog intermediateResult2) {
        try {
            intermediateResult1.addAll(intermediateResult2);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLog", e);
        }
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Long extractFinalResult(@Nonnull HyperLogLog intermediateResult) {
        return intermediateResult.cardinality();
    }

    private HyperLogLog getHyperLogLog(@Nonnull AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(this._log2m);
            aggregationResultHolder.setValue(hyperLogLog);
        }
        return hyperLogLog;
    }

    private HyperLogLog getHyperLogLog(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(this._log2m);
            groupByResultHolder.setValueForKey(groupKey, hyperLogLog);
        }
        return hyperLogLog;
    }
}

