/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.common.utils.DataSchema;

public class MinAggregationFunction
implements AggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = Double.POSITIVE_INFINITY;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MIN;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.MIN.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(Double.POSITIVE_INFINITY);
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        double min = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            if (!(value < min)) continue;
            min = value;
        }
        aggregationResultHolder.setValue(min);
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            int groupKey = groupKeyArray[i];
            if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
            groupByResultHolder.setValueForKey(groupKey, value);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    @Nonnull
    public Double extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    @Nonnull
    public Double extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    @Nonnull
    public Double merge(@Nonnull Double intermediateResult1, @Nonnull Double intermediateResult2) {
        if (intermediateResult1 < intermediateResult2) {
            return intermediateResult1;
        }
        return intermediateResult2;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull Double intermediateResult) {
        return intermediateResult;
    }
}

