/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class MinMaxRangeAggregationFunction
implements AggregationFunction<MinMaxRangePair, Double> {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MINMAXRANGE;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.MINMAXRANGE.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
                this.setAggregationResult(aggregationResultHolder, min, max);
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < length; ++i) {
                    MinMaxRangePair value = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                    if (value.getMin() < min) {
                        min = value.getMin();
                    }
                    if (!(value.getMax() > max)) continue;
                    max = value.getMax();
                }
                this.setAggregationResult(aggregationResultHolder, min, max);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MIN_MAX_RANGE aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    protected void setAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder, double min, double max) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)aggregationResultHolder.getResult();
        if (minMaxRangePair == null) {
            aggregationResultHolder.setValue(new MinMaxRangePair(min, max));
        } else {
            minMaxRangePair.apply(min, max);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, value, value);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    MinMaxRangePair value = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, value.getMin(), value.getMax());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MIN_MAX_RANGE aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value, value);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    MinMaxRangePair value = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value.getMin(), value.getMax());
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MIN_MAX_RANGE aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    protected void setGroupByResult(int groupKey, @Nonnull GroupByResultHolder groupByResultHolder, double min, double max) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)groupByResultHolder.getResult(groupKey);
        if (minMaxRangePair == null) {
            groupByResultHolder.setValueForKey(groupKey, new MinMaxRangePair(min, max));
        } else {
            minMaxRangePair.apply(min, max);
        }
    }

    @Override
    @Nonnull
    public MinMaxRangePair extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)aggregationResultHolder.getResult();
        if (minMaxRangePair == null) {
            return new MinMaxRangePair(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return minMaxRangePair;
    }

    @Override
    @Nonnull
    public MinMaxRangePair extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)groupByResultHolder.getResult(groupKey);
        if (minMaxRangePair == null) {
            return new MinMaxRangePair(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return minMaxRangePair;
    }

    @Override
    @Nonnull
    public MinMaxRangePair merge(@Nonnull MinMaxRangePair intermediateResult1, @Nonnull MinMaxRangePair intermediateResult2) {
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull MinMaxRangePair intermediateResult) {
        return intermediateResult.getMax() - intermediateResult.getMin();
    }
}

